<?php

namespace App\Providers;

use App\Setting;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\ServiceProvider;
use Plugins\Sms\SmsBuilder;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind('patronic-sms', function () {
            return new SmsBuilder();
        });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {

        Blade::component('components.modal', 'modal');

        if (env('APP_LICENSE_KEY')) {
            $globalSettings = Setting::where('is_global', true)->get()->toArray();
            foreach ($globalSettings as $setting) {
                config([$setting['config_name'] => $setting['config_value']]);
            }
        }

        Blade::directive('jalali', function ($datetime) {
            if (strpos($datetime, ',') !== false) {
                if ((explode(',', $datetime)[1]) == 'true') {
                    $date = explode(',', $datetime)[0];
                    return "<?php echo jdate({$date})->ago(); ?>";
                }
                list($date,$format) = explode(',', $datetime);
            } else {
                $date = $datetime;
                $format = 'H:i:s Y/m/d';
            }
            return "<?php echo jdate({$date})->format('{$format}'); ?>";
        });
    }
}
