
<?php $__env->startSection('title', 'دپارتمان ها'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item active">دپارتمان ها</li>
                    </ol>
                </div>
                <h4 class="page-title">دپارتمان ها</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col">
            <div class="card-box">
                <div class="clearfix">
                    <div class="float-left">
                        <h4 class="header-title">لیست درپارتمان ها</h4>
                        <p class="sub-header">لیست تمامی دپارتمان ها به همراه اطلاعات</p>
                    </div>
                    <button type="button" class="btn btn-primary waves-effect waves-light float-right mb-3" data-toggle="modal" data-target="#addDepartmentModal"><i class="fe-folder-plus mr-2 align-middle"></i>افزودن دپارتمان جدید</button>
                </div>
                <?php if(session('success')): ?>
                    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                <?php endif; ?>
                <div class="table-responsive">
                    <table class="table table-hover text-center">
                        <thead class="thead-light">
                        <tr>
                            <th>#</th>
                            <th>نام</th>
                            <th>تعداد پشتیبانان</th>
                            <th>تعداد تیکت ها</th>
                            <th>وضعیت</th>
                            <th>گزینه ها</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($department->id); ?></td>
                                <td><?php echo e($department->name); ?></td>
                                <td><label class="badge label-table badge-light-primary"><?php echo e($department->users_count); ?> تا </label></td>
                                <td><label class="badge label-table badge-light-primary"><?php echo e($department->tickets_count); ?> تا </label></td>
                                <td><?php echo department_status_label($department->is_hidden); ?></td>
                                <td>
                                    <a href="<?php echo e(route('panel.departments.edit', $department)); ?>" class="btn btn-secondary btn-xs">
                                        <span class="remixicon-folder-settings-line"></span>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <td colspan="6" class="bg-light text-muted text-center">داده ای یافت نشد</td>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php echo e($departments->links()); ?>

            </div>
        </div><!-- end col -->
    </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iphoneun/public_html/peygirsho.ir/patronic/resources/views/panel/departments/list.blade.php ENDPATH**/ ?>