@extends('layouts.public-master')
@section('title', 'اخبار - ')
@section('main')

<main class="container mb-5">
    <h2 class="mb-4">اخبار</h2>
    <div class="row">
        <div class="col-12">
            @forelse($news as $newsItem)
                <div class="news-item" id="news-{{ $newsItem->id }}">
                    <div class="clearfix news-title">
                        <h5 class="header-title float-right"><a href="{{ route('news.show', $newsItem) }}">{{ $newsItem->title }}</a></h5>
                        <small class="float-left text-muted">@jalali($newsItem->created_at,Y/m/d)</small>
                    </div>
                    <div class="news-excerpt">
                        {{ Illuminate\Support\Str::words(strip_tags($newsItem->content), 50, '...') }}
                    </div>
                </div>
            @empty
                <h3>اخباری یافت نشد!</h3>
            @endforelse
        </div>
    </div>

</main>
@endsection