<div id="patronicLatestNewsCarousel" class="carousel slide">
    <ol class="carousel-indicators">
        @foreach($patronicNews as $newsItem)
        <li data-target="#patronicLatestNewsCarousel" data-slide-to="{{ $loop->index }}" @if($loop->first) class="active" @endif></li>
        @endforeach
    </ol>
    <div class="carousel-inner">
        @foreach($patronicNews as $newsItem)
        <div class="carousel-item @if($loop->first) active @endif">
            <div class="row mb-3">
                <div class="col">
                    <div class="latest-news-item card-box mb-0">
                        <div class="latest-news-header">
                            <h4 class="mt-0 mb-2">
                                <a class="text-secondary" href="{{ $newsItem['link'] }}">{{ $newsItem['title']['rendered'] }}</a>
                                @if (\Carbon\Carbon::createFromTimeString($newsItem['date'])->diffInHours() < 48)
                                    <small class="text-danger">(جدید)</small>
                                @endif
                            </h4>
                            <span class="text-muted">@jalali($newsItem['date'], Y-m-d)</span>
                        </div>
                        <div class="latest-news-excerpt mb-2">{{ \Illuminate\Support\Str::words(strip_tags($newsItem['content']['rendered']), 25) }}</div>
                    </div>
                </div>
            </div>
        </div>
        @endforeach
    </div>
</div>
