@extends('layouts.master')
@section('title', 'ویرایش کاربر')

@section('breadcrumb')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('panel.users.index') }}">کاربران</a></li>
                        <li class="breadcrumb-item active">ویرایش کاربر</li>
                    </ol>
                </div>
                <h4 class="page-title">ویرایش کاربر</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col">
            <div class="card-box clearfix">
                @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                <form action="{{ route('panel.users.update', $user) }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="col-12">
                            <div class="p-1">
                                <div class="form-group">
                                    <label for="name" class="form-label">نام و نام خانوادگی</label>
                                    <input type="text" name="name" class="form-control @error('name') is-invalid @enderror" id="name" placeholder="نام و نام خانوادگی را وارد کنید" value="{{ $user->name }}" required/>
                                    @error('name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="email" class="form-label">ایمیل</label>
                                    <input type="email" name="email" class="form-control @error('email') is-invalid @enderror" id="email" placeholder="مثال: email@site.com" value="{{ $user->email }}" required/>
                                    @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="mobile" class="form-label">شماره موبایل</label>
                                    <input type="text" name="mobile" class="form-control @error('mobile') is-invalid @enderror" id="mobile" placeholder="مثال: 09123456789" title="شماره تماس 11 رقمی مانند: 09123456789" pattern="09\d{9}" value="{{ $user->mobile }}" required/>
                                    @error('mobile')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="username" class="col-form-label">نام کاربری</label>
                                    <input type="text" size="20" maxlength="20" id="username" name="username" value="{{ $user->username }}" class="form-control @error('username') is-invalid @enderror" placeholder="مثال : ali_22">
                                    @error('username')
                                    <div class="invalid-feedback">
                                        <strong>{{ $message }}</strong>
                                    </div>
                                    @else
                                    <small class="form-text text-muted">حداکثر میتوانید 20 کارکتر وارد کنید.کارکترهای مجاز: حروف،اعداد،-،ـ </small>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="password" class="form-label">کلمه عبور</label>
                                    <input type="password" name="password" class="form-control @error('password') is-invalid @enderror" id="password" placeholder="کلمه عبور را وارد کنید" title="حداقل 8 کارکتر" min="8" aria-describedby="passwordDesc"/>
                                    <small class="form-text text-muted" id="passwordDesc">در صورتی که نمیخواهید کلمه عبور کاربر را تغییر دهید این بخش را خالی رها کنید</small>
                                    @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <div class="card text-white bg-light">
                                        <div class="card-body">
                                            <div>
                                                <img class="rounded-circle" src="{{ $user->getFirstMediaUrl('avatar') ? url($user->getFirstMediaUrl('avatar')) : asset('assets/images/default-avatar.png') }}" width="33" alt="تصویر پروفایل">
                                                <h5 class="mt-0 mb-3 d-inline-block">تصویر پروفایل</h5>
                                            </div>
                                            <div class="fileupload btn btn-sm btn-secondary waves-effect mt-1">
                                                <span><i class="mdi mdi-cloud-upload mr-1"></i>انتخاب تصویر جدید</span>
                                                <input type="file" name="avatar" class="upload">
                                            </div>
                                            @error('avatar')
                                            <span class="text-danger" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="signature" class="form-label">امضا</label>
                                    <textarea name="signature" class="form-control" id="signature" placeholder="متن امضا را وارد کنید..." cols="30" rows="4">{{ $user->signature }}</textarea>
                                    @error('signature')
                                    <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <p>وضعیت</p>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" id="activeStatus" name="status" class="custom-control-input" {{ $user->status == 'active' ? 'checked' : '' }} value="active">
                                        <label class="custom-control-label" for="activeStatus">فعال</label>
                                    </div>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" id="disabledStatus" name="status" class="custom-control-input" {{ $user->status == 'disabled' ? 'checked' : '' }} value="disabled">
                                        <label class="custom-control-label" for="disabledStatus">غیر فعال</label>
                                    </div>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" id="bannedStatus" name="status" class="custom-control-input" {{ $user->status == 'banned' ? 'checked' : '' }} value="banned">
                                        <label class="custom-control-label" for="bannedStatus">مسدود شده</label>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" {{ $user->mobile_verified_at ? 'checked' : '' }} id="mobileVerified" name="mobileVerified" value="{{ $user->mobile_verified_at ?: \Carbon\Carbon::now() }}">
                                        <label class="custom-control-label" for="mobileVerified">موبایل تایید شده است</label>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" {{ $user->email_verified_at ? 'checked' : '' }} id="emailVerified" name="emailVerified" value="{{ $user->email_verified_at ?: \Carbon\Carbon::now() }}">
                                        <label class="custom-control-label" for="emailVerified">ایمیل تایید شده است</label>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary waves-effect waves-light float-right">ذخیره</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div><!-- end col -->
    </div>

@endsection