@extends('layouts.master')

@section('css')
    <link rel="stylesheet" href="{{ asset('assets/css/morris.min.css') }}"/>
@endsection

@section('breadcrumb')
<!-- start page title -->
<div class="row">
    <div class="col-12">
        <div class="page-title-box">
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                    <li class="breadcrumb-item active">پیشخوان</li>
                </ol>
            </div>
            <h4 class="page-title">خوش آمدید</h4>
        </div>
    </div>
</div>
<!-- end page title -->
@endsection

@section('content')
    @if(session('updateStatus'))
        <div class="alert alert-success">بروزرسانی با موفقیت انجام شد</div>
    @endif

    @if($update)
        <div class="row">
            <div class="col">
                <div class="alert alert-info">
                    <span>پاترونیک آماده بروزرسانی می‌باشد</span>
                    <small><a href="javascript:void(0)" data-target="#updateModal__{{str_replace(".", '_', $update)}}" data-toggle="modal">(مشاهده لیست تغییرات)</a></small>
                    <form action="{{ route('update') }}" method="post" role="form" class="mt-2">
                        @csrf
                        <button class="btn btn-sm btn-primary">بروزرسانی به نسخه {{ $update }}</button>
                    </form>
                </div>
            </div>
        </div>

        <x-modal title="تغییرات نسخه {{$update}}" id="updateModal__2_4_0">
            <ul class="p-2">
                <li>اضافه شدن امکان ارسال پیامک با پترن</li>
                <li>اضافه شدن امکان تغییر وب‌سرویس پیامک</li>
                <li>رفع عیوب گزارش شده</li>
                <li>بهبود عملکرد و سرعت و افزایش پایداری</li>
            </ul>
        </x-modal>

        <x-modal title="تغییرات نسخه {{$update}}" id="updateModal__2_5_0">
            <ul class="p-2">
                <li>تغییر ظاهری صفحه داشبورد ادمین</li>
                <li>رفع باگ ارسال پیامک</li>
                <li>حذف امکان جستجو تیکت براساس کدپیگیری از صفحه اصلی (به زودی مجددا اضافه خواهد شد)</li>
                <li>حذف امکان پاک کردن دپارتمان</li>
                <li>بهبود عملکرد و سرعت و افزایش پایداری</li>
            </ul>
        </x-modal>

        <x-modal title="تغییرات نسخه {{$update}}" id="updateModal__2_6_0">
            <ul class="p-2">
                <li>اضافه شدن پنل پیامکی ippanel</li>
                <li>بهبود عملکرد و سرعت و افزایش پایداری</li>
            </ul>
        </x-modal>

        <x-modal title="تغییرات نسخه {{$update}}" id="updateModal__2_7_3">
            <ul class="p-2">
                <li>اضافه شدن «پاسخ آماده».پاسخ‌های پرتکرار خود را به صورت پاسخ آماده ذخیره کنید تا بتوانید در سریعترین زمان و به راحتی از آن‌ها استفاده کنید</li>
                <li>تغییر طراحی صفحه مشاهده تیکت</li>
                <li>رفع عیوب گزارش شده و بهبود عملکرد</li>
            </ul>
        </x-modal>

    @endif

<div class="row d-none">
    <div class="col">
        <div class="widget-bg-color-icon card-box">
            <div class="avatar-lg rounded-circle bg-icon-primary float-left">
                <i class="remixicon-chat-4-line font-24 avatar-title text-white"></i>
            </div>
            <div class="text-right">
                <h3 class="text-dark mt-1"><span class="counter">{{ $allTicketsCount }}</span></h3>
                <p class="text-muted mb-0">کل تیکت ها</p>
            </div>
            <div class="clearfix"></div>
        </div>
    </div>
    <div class="col">
        <div class="widget-bg-color-icon card-box">
            <div class="avatar-lg rounded-circle bg-icon-warning float-left">
                <i class="remixicon-feedback-line font-24 avatar-title text-white"></i>
            </div>
            <div class="text-right">
                <h3 class="text-dark mt-1"><span class="counter">{{ $unreadTicketsCount }}</span></h3>
                <p class="text-muted mb-0">خوانده نشده</p>
            </div>
            <div class="clearfix"></div>
        </div>
    </div>
    <div class="col">
        <div class="widget-bg-color-icon card-box">
            <div class="avatar-lg rounded-circle bg-icon-success float-left">
                <i class="remixicon-chat-check-line font-24 avatar-title text-white"></i>
            </div>
            <div class="text-right">
                <h3 class="text-dark mt-1"><span class="counter">{{ $repliedTicketsCount }}</span></h3>
                <p class="text-muted mb-0">پاسخ داده شده</p>
            </div>
            <div class="clearfix"></div>
        </div>
    </div>
    <div class="col">
        <div class="widget-bg-color-icon card-box">
            <div class="avatar-lg rounded-circle bg-icon-danger float-left">
                <i class="remixicon-chat-delete-line font-24 avatar-title text-white"></i>
            </div>
            <div class="text-right">
                <h3 class="text-dark mt-1"><span class="counter">{{ $closedTicketsCount }}</span></h3>
                <p class="text-muted mb-0">بسته شده</p>
            </div>
            <div class="clearfix"></div>
        </div>
    </div>
</div>

    <div class="row" id="charts">
        <div class="col-sm-4">
            <div class="card-box">
                <h4 class="header-title">نمودار تعداد تیکت‌ها</h4>
                <p class="sub-header mb-0">بر اساس وضعیت تیکت ها</p>
                <div id="ticketsDonutChart" style="height: 350px;" class="morris-chart" data-colors="#3bafda,#1abc9c,#ebeff2"></div>
            </div>
        </div>
        <div class="col-sm-8">
            <div class="card-box">
                <h4 class="header-title">نمودار روزانه تیکت‌ها</h4>
                <p class="sub-header mb-1">براساس وضعیت تیکت‌ها</p>
                <div id="ticketsStackedChart" class="morris-chart"></div>
            </div>
        </div>
    </div>

<div class="row" id="adminPanelWidgets">
    <div class="col-sm-4">
        <div id="patronicNews">
            <div class="card-box">
                <span class="fa fa-spinner fa-spin"></span><span>درحال دریافت اطلاعات</span>
            </div>
        </div>
    </div>
    <div class="col-sm-4">
        <div id="superiorStaffsSection">
            <div class="card-box">
                <h4 class="header-title">برترین پشتیبان ها</h4>
                <p class="sub-header mb-1">بر اساس امتیازات دریافتی از پاسخ‌ها</p>
                <ol class="p-0">
                @forelse($superiorStaffs as $staff)
                    <li class="py-1">
                        {{ $staff->name}} ({{ $staff->rate }} امتیاز)
                        <p>
                            <small class="text-black-50"> {{ App\User::where('id', $staff->user_id)->first()->replies()->count() }} پاسخ ارسال کرده است</small>
                        </p>
                    </li>
                @empty
                    <div class="alert alert-secondary">اطلاعاتی یافت نشد</div>
                @endforelse
                </ol>
            </div>
        </div>
    </div>
    <div class="col-sm-4">
        <div id="latestReports">
            <div class="card-box" style="min-height: 180px;">
                <h4 class="header-title">گزارشات</h4>
                <p class="sub-header mb-1">آخرین تیکت‌ها و پاسخ‌های گزارش شده</p>
                <ul style="list-style: none">
                    @forelse($reports as $report)
                        <li class="p-1 bg-light mb-1">
                            <a href="{{ route('panel.reports.show', $report) }}">#{{ $report->id }}</a>
                            توسط <a href="{{ route('panel.users.edit', $report->user) }}">{{ $report->user->name }}</a>
                            در
                            <a href="{{ route('panel.tickets.show', $report->ticket) }}">تیکت شماره {{ $report->ticket->id }}</a>
                            <small class="text-muted">(@jalali($report->created_at,true))</small>
                        </li>
                    @empty
                        <div class="alert alert-secondary">اطلاعاتی یافت نشد</div>
                    @endforelse
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script-bottom')
    <script src="{{ asset('assets/js/morris.min.js') }}"></script>
    <script src="{{ asset('assets/js/raphael.min.js') }}"></script>

    <script>
        $(document).ready(function () {
            $.ajax({
                url: "{{ route('patronic.news') }}",
                type: "GET",
                success: function(data) {
                    $('#patronicNews').html(data);
                },
                error: function(err) {
                    $('#patronicNews').html('<div class="alert alert-warning">خطایی در بارگذاری اطلاعات رخ داد</div>');
                }
            });

            Morris.Donut({
                element: $('#ticketsDonutChart'),
                data: [
                    {label: "خوانده نشده", value: {{ $unreadTicketsCount }} },
                    {label: "خوانده شده", value: {{ $readTicketsCount }} },
                    {label: "پاسخ داده شده", value: {{ $repliedTicketsCount }} },
                    {label: "بسته شده", value: {{ $closedTicketsCount }} },
                ],
                barSize: 0.9,
                resize: true,
                colors: ['#f7b84b','#f1f5f7', '#3bafda', '#f1556c'],
                backgroundColor: 'transparent'
            });

            var $stckedData  = {!! $ticketsWeeklyDataForChart !!};
            var colors = ['#f1f5f7','#f7b84b','#3bafda', '#f1556c'];

            Morris.Bar({
                element: $('#ticketsStackedChart'),
                data: $stckedData,
                xkey: 'date',
                ykeys: ['read', 'unread', 'replied', 'closed'],
                stacked: true,
                labels: ["خوانده شده", "خوانده نشده", "پاسخ داده شده", "بسته شده"],
                hideHover: 'auto',
                dataLabels: false,
                resize: true, //defaulted to true
                gridLineColor: 'rgba(65, 80, 95, 0.07)',
                barColors: colors
            });

        });
    </script>
@endpush
