@extends('layouts.master')
@section('title', 'دپارتمان ها')

@section('breadcrumb')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item active">دپارتمان ها</li>
                    </ol>
                </div>
                <h4 class="page-title">دپارتمان ها</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col">
            <div class="card-box">
                <div class="clearfix">
                    <div class="float-left">
                        <h4 class="header-title">لیست درپارتمان ها</h4>
                        <p class="sub-header">لیست تمامی دپارتمان ها به همراه اطلاعات</p>
                    </div>
                    <button type="button" class="btn btn-primary waves-effect waves-light float-right mb-3" data-toggle="modal" data-target="#addDepartmentModal"><i class="fe-folder-plus mr-2 align-middle"></i>افزودن دپارتمان جدید</button>
                </div>
                @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                <div class="table-responsive">
                    <table class="table table-hover text-center">
                        <thead class="thead-light">
                        <tr>
                            <th>#</th>
                            <th>نام</th>
                            <th>تعداد پشتیبانان</th>
                            <th>تعداد تیکت ها</th>
                            <th>وضعیت</th>
                            <th>گزینه ها</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($departments as $department)
                            <tr>
                                <td>{{ $department->id }}</td>
                                <td>{{ $department->name }}</td>
                                <td><label class="badge label-table badge-light-primary">{{ $department->users_count }} تا </label></td>
                                <td><label class="badge label-table badge-light-primary">{{ $department->tickets_count }} تا </label></td>
                                <td>{!! department_status_label($department->is_hidden) !!}</td>
                                <td>
                                    <a href="{{ route('panel.departments.edit', $department) }}" class="btn btn-secondary btn-xs">
                                        <span class="remixicon-folder-settings-line"></span>
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <td colspan="6" class="bg-light text-muted text-center">داده ای یافت نشد</td>
                        @endforelse
                        </tbody>
                    </table>
                </div>
                {{ $departments->links() }}
            </div>
        </div><!-- end col -->
    </div>

@endsection