@extends('layouts.master-blank')
@section('title','تایید حساب کاربری')
@section('css')
    <link rel="stylesheet" href="{{ asset('assets/css/passtrength.min.css') }}"/>
@endsection
@section('content')
    <div class="account-pages mt-5 mb-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-8 col-lg-6 col-xl-5">
                    <div class="card">

                        <div class="card-body p-4">

                            <div class="text-center w-75 m-auto">
                                <a href="{{ config('site_url') }}">
                                    @if(config('site_logo'))
                                        <h1 class="text-logo-lg">{{ config('site_logo') }}</h1>
                                    @else
                                        <img src="{{ config('site_logo_img') ?: asset('assets/images/patronic-logo-dark.png') }}" alt="SITE LOGO" height="40">
                                    @endif
                                </a>
                                <p class="text-muted mb-4 mt-3">تایید شماره موبایل</p>
                            </div>
                            @error('error')
                            <div class="alert alert- alert-danger" id="verificationError">{{ $message }}</div>
                            @enderror
                            @if(session('mobile'))
                                <div class="alert alert-info" role="alert">
                                    <i class="mdi mdi-alert-circle-outline mr-2"></i>برای تایید شماره موبایل کد تاییدی که از طریق پیامک دریافت کرده اید را وارد کنید
                                </div>
                            @endif
                            <div id="result" style="display:none">
                                <div class="alert alert-success" role="alert" style="display:none;">
                                    <i class="mdi mdi-check-all mr-2"></i>
                                    <span id="successText"></span>
                                </div>
                                <div class="alert alert-danger" role="alert" style="display:none;">
                                    <i class="mdi mdi-block-helper mr-2"></i>
                                    <span id="errorText"></span>
                                </div>
                            </div>
                            <form action="{{ route('verify.mobile') }}" method="post">
                                @csrf
                                <div class="form-group mb-3">
                                    <label for="mobile">شماره همراه</label>
                                    <input class="form-control @error('mobile') is-invalid @enderror" pattern="09\d{9}" title="مثال: 09123456789" value="{{ session('mobile') ?? old('mobile') }}" name="mobile" type="text" id="mobile" placeholder="شماره همراه" required/>
                                    @error('mobile')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>

                                <div class="form-group mb-3">
                                    <label for="verificationCode">کد تایید</label>
                                    <input class="form-control @error('verificationCode') is-invalid @enderror" pattern="\d{6}" title="کد 6 رقمی مانند : 123456" name="verificationCode" type="text" id="verificationCode" placeholder="کد تایید را وارد کنید" required/>
                                    @error('verificationCode')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                    <div class="text-right text-primary">
                                        <small class="mt-1">
                                            <a href="javascript:void(0)" id="resendVerificationCode">ارسال مجدد کد
                                                فعالسازی</a>
                                        </small>
                                    </div>
                                </div>

                                <div class="form-group mb-0 text-center">
                                    <button class="btn btn-primary btn-block" type="submit">تایید شماره موبایل</button>
                                </div>
                            </form>
                        </div> <!-- end card-body -->
                    </div>
                    <!-- end card -->

                    <div class="row mt-3">
                        <div class="col-12 text-center">
                            <p>بازگشت به<a href="{{ route('login') }}" class="font-weight-medium ml-1">صفحه ورود</a></p>
                        </div> <!-- end col -->
                    </div>
                    <!-- end row -->
                </div> <!-- end col -->
            </div>
            <!-- end row -->
        </div>
        <!-- end container -->
    </div>
    <!-- end page -->


    @component('components.copyright') @endcomponent
@endsection

@push('script-bottom')
    <script>
        $('#resendVerificationCode').click(function (e) {
            e.preventDefault();
            var link = $(this);
            if ($('#mobile').val() === '') {
                return alert('شماره موبایل خود را وارد کنید');
            } else if (!$('#mobile').val().match(/09\d{9}/)) {
                return alert('شماره موبایل وارد شده نامعتبر میباشد');
            }

            link.text('در حال ارسال مجدد کد فعالسازی...');
            $('.card').css('opacity', '0.6');
            $('#verificationError').fadeOut();

            $.ajax({
                type: 'POST',
                dataType: 'json',
                url: "{{ route('verify.mobile.resend') }}",
                data: {mobile: $('#mobile').val()},
                success: function (response) {
                    if (response.status === 'success') {
                        $('#result').find('.alert-danger').fadeOut();
                        $('#result').find('.alert-success').fadeIn();
                        $('#successText').text(response.msg);
                    } else if (response.status === 'fail') {
                        $('#result').find('.alert-success').fadeOut();
                        $('#result').find('.alert-danger').fadeIn();
                        $('#errorText').text(response.msg);
                    }

                },
                complete: function () {
                    $('#result').fadeIn();
                    link.text('ارسال مجدد کد فعالسازی');
                    $('.card').css('opacity', '1');
                },
                error: function (error) {
                    if (error.hasOwnProperty('responseJSON')) {
                        $('.alert-success').fadeOut();
                        $('.alert-danger').fadeIn();
                        $('#errorText').text(error.responseJSON.message);
                    }
                },
            });
        });
    </script>
@endpush