@extends('layouts.master-blank')
@section('title', 'فراموشی کلمه عبور')
@section('content')
<div class="account-pages mt-5 mb-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6 col-xl-5">
                <div class="card">
                    <div class="card-body p-4">
                        <div class="text-center w-75 m-auto">
                            <a href="{{ config('site_url') }}">
                                @if(config('site_logo'))
                                    <h1 class="text-logo-lg">{{ config('site_logo') }}</h1>
                                @else
                                    <img src="{{ config('site_logo_img') ?: asset('assets/images/patronic-logo-dark.png') }}" alt="SITE LOGO" height="40">
                                @endif
                            </a>
                            <p class="text-muted mb-4 mt-3">ایمیل خود را وارد کنید و ما لینک بازیابی کلمه عبور را برای شما از طریق ایمیل ارسال خواهیم کرد</p>
                        </div>
                        @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                        @endif

                        <form action="{{ route('password.email') }}" method="post">
                            @csrf
                            <div class="form-group mb-3">
                                <label for="emailaddress">ایمیل</label>
                                <input class="form-control @error('email') is-invalid @enderror" name="email" type="email" id="emailaddress" placeholder="ایمیل خود را وارد کنید" required>
                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            <div class="form-group mb-0 text-center">
                                <button class="btn btn-primary btn-block" type="submit">ارسال لینک بازیابی</button>
                            </div>
                        </form>
                    </div> <!-- end card-body -->
                </div>
                <!-- end card -->

                <div class="row mt-3">
                    <div class="col-12 text-center">
                        <p class="text-muted">بازگشت به<a href="{{ route('login') }}" class="font-weight-medium ml-1">صفحه ورود</a></p>
                    </div> <!-- end col -->
                </div>
                <!-- end row -->
            </div> <!-- end col -->
        </div>
        <!-- end row -->
    </div>
    <!-- end container -->
</div>
<!-- end page -->


@component('components.copyright') @endcomponent
@endsection