<?php

namespace App\Http\Controllers\panel;

use App\Http\Controllers\Controller;
use App\Post;
use App\QuickResponse;
use Illuminate\Http\Request;

class QuickResponseController extends Controller
{
    public function index()
    {
        $quickResponses = QuickResponse::latest()->paginate(20);
        return view('panel.quick-responses.list', compact('quickResponses'));
    }

    public function create()
    {
        return view('panel.quick-responses.add');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'title' => ['required', 'string', 'min:3', 'max:191'],
            'text' => ['required', 'string', 'min:3', 'max:1000'],
        ]);

        QuickResponse::create($validated);

        return redirect()->route('panel.quick-responses.index')->withSuccess('با موفقیت اضافه شد');
    }

    public function edit(Request $request, QuickResponse $quickResponse)
    {
        return view('panel.quick-responses.edit', compact('quickResponse'));
    }

    public function update(Request $request, QuickResponse $quickResponse)
    {
        $validated = $request->validate([
            'title' => ['required', 'string', 'min:3', 'max:191'],
            'text' => ['required', 'string', 'min:3', 'max:1000'],
        ]);

        $quickResponse->update($validated);

        return redirect()->route('panel.quick-responses.index')->withSuccess('با موفقیت ویرایش شد');
    }
}
