@extends('layouts.public-master')
@section('title', 'نتایج جستجو - ')
@section('main')

<main class="container mb-5">
    <h2 class="mb-4">نتایج جستجو برای : {{ $searchTerm }}</h2>
    <div class="row">
        <div class="col-12">
            <div id="accordion">
                @forelse($posts as $post)
                    <div class="news-item" id="news-{{ $post->id }}">
                        <div class="clearfix news-title">
                            <h5 class="header-title float-right"><a href="{{ route('news.show', $post) }}">{{ $post->title }}</a></h5>
                            <small class="float-left text-muted">@jalali($post->created_at,Y/m/d)</small>
                        </div>
                        <div class="news-excerpt">
                            {{ Illuminate\Support\Str::words(strip_tags($post->content), 50, '...') }}
                        </div>
                    </div>
                @empty
                    <div class="alert alert-warning">متاسفانه برای عبارت جستجو شده مطلب مرتبطی یافت نشد.می‌توانید با ورود به بخش پشتیبانی سوال یا درخواست خود را مطرح کنید.</div>
                @endforelse
            </div>
        </div>
    </div>
</main>

@endsection