@extends('layouts.master')
@section('title', 'پاسخ‌های آماده')

@section('breadcrumb')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item active">پاسخ‌های آماده</li>
                    </ol>
                </div>
                <h4 class="page-title">پاسخ‌های آماده</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col">
            <div class="card-box">
                <div class="clearfix">
                    <div class="float-left">
                        <h4 class="header-title">لیست پاسخ‌های آماده</h4>
                    </div>
                    <a href="{{ route('panel.quick-responses.create') }}" class="btn btn-primary waves-effect waves-light float-right mb-3"><i class="fe-folder-plus mr-2 align-middle"></i>افزودن</a>
                </div>
                @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                <div class="table-responsive">
                    <table class="table table-hover text-center">
                        <thead class="thead-light">
                        <tr>
                            <th>#</th>
                            <th>عنوان</th>
                            <th>متن</th>
                            <th>آخرین ویرایش</th>
                            <th>گزینه ها</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($quickResponses as $quickResponse)
                            <tr>
                                <td>{{ $quickResponse->id }}</td>
                                <td>{{ $quickResponse->title }}</td>
                                <td>{{ \Illuminate\Support\Str::words($quickResponse->text, 15) }}</td>
                                <td><span data-toggle="tooltip" title="@jalali($quickResponse->created_at,H:i:s Y/m/d)">@jalali($quickResponse->created_at,true)</span></td>
                                <td>
                                    <a href="{{ route('panel.quick-responses.edit', $quickResponse) }}" class="btn btn-secondary btn-xs">
                                        <span class="remixicon-folder-settings-line"></span>
                                    </a>
                                </td>
                            </tr>
                        @empty
                            <td colspan="5" class="bg-light text-muted text-center">داده ای یافت نشد</td>
                        @endforelse
                        </tbody>
                    </table>
                </div>
                {{ $quickResponses->links() }}
            </div>
        </div><!-- end col -->
    </div>

@endsection