<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Report extends Model
{
    protected $guarded = [];

    public function ticket()
    {
        return $this->belongsTo(Ticket::class);
    }

    public function reply()
    {
        return $this->belongsTo(Reply::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function isForReply()
    {
        if ($this->reply_id) {
            return true;
        }
        return false;
    }

    public function isRead()
    {
        return $this->read_at;
    }

    public static function countUnread()
    {
        return static::whereNull('read_at')->count();
    }
}
