
<?php $__env->startSection('title', 'تنظیمات تیکت'); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/jquery.bootstrap-touchspin.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('panel.settings.general')); ?>">تنظیمات</a></li>
                        <li class="breadcrumb-item active">تیکت</li>
                    </ol>
                </div>
                <h4 class="page-title">تنظیمات تیکت</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col">
            <div class="card-box">
                <?php if(session('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>
                <form action="<?php echo e(route('panel.settings.ticket.update')); ?>" class="form-horizontal" method="post" role="form">
                    <?php echo method_field('patch'); ?>
                    <?php echo csrf_field(); ?>
                    <div class="alert alert-light border-right">تنظیماتی که با علامت ستاره(*) مشخص شده اند تنها برای نوع کاربری "کاربر" اعمال میگردد و تاثیری در امکانات و دسترسی های پشتیبانان و مدیران نخواهد داشت
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="CanUserChangeDepartment">* تعویض دپارتمان تیکت</label>
                        <div class="col-sm-10 p-1 pl-2">
                            <input type="checkbox" id="CanUserChangeDepartment" data-plugin="switchery" data-size="small" data-color="#1AB394" data-secondary-color="#ED5565" name="can_user_change_department" <?php if($settings['can_user_change_department']): ?> checked <?php endif; ?> value="1"/>
                            <small class="form-text text-muted">با غیر فعال کردن این گزینه کاربران قادر نخواهند بود دپارتمان تیکت را تغییر دهند</small>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="CanUserCloseTicket"> * بستن تیکت<i class="fa fa-question-circle ml-1" data-toggle="tooltip" title="با بسته شدن تیکت کاربران امکان پاسخ به تیکت را نخواهند داشت"></i></label>
                        <div class="col-sm-10 p-1 pl-2">
                            <input type="checkbox" id="CanUserCloseTicket" data-plugin="switchery" data-size="small" data-color="#1AB394" data-secondary-color="#ED5565" name="can_user_close_ticket" <?php if($settings['can_user_close_ticket']): ?> checked <?php endif; ?> value="1"/>
                            <small class="form-text text-muted">با غیر فعال کردن این گزینه کاربران قادر نخواهند بود تیکت را به حالت بسته تغییر وضعیت دهند</small>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="CanUserReopenTicket"> * بازگشایی تیکت<i class="fa fa-question-circle ml-1" data-toggle="tooltip" title="با بازگشایی تیکت کاربران مجددا امکان پاسخ به تیکت را خواهند داشت"></i></label>
                        <div class="col-sm-10 p-1 pl-2">
                            <input type="checkbox" id="CanUserReopenTicket" data-plugin="switchery" data-size="small" data-color="#1AB394" data-secondary-color="#ED5565" name="can_user_reopen_ticket" <?php if($settings['can_user_reopen_ticket']): ?> checked <?php endif; ?> value="1"/>
                            <small class="form-text text-muted">با غیر فعال کردن این گزینه کاربران قادر نخواهند بود تیکت را به حالت باز تغییر وضعیت دهند</small>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="CanUserAttachFileToTicket">* افزودن فایل به تیکت</label>
                        <div class="col-sm-10 p-1 pl-2">
                            <input type="checkbox" id="CanUserAttachFileToTicket" data-plugin="switchery" data-size="small" data-color="#1AB394" data-secondary-color="#ED5565" name="can_user_attach_file" <?php if($settings['can_user_attach_file']): ?> checked <?php endif; ?> value="1"/>
                            <small class="form-text text-muted">با غیر فعال کردن این گزینه کاربران قادر نخواهند بود فایلی را به تیکت ها اضافه کنند</small>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="CanStaffCreateTicket">ایجاد تیکت توسط پشتیبان</label>
                        <div class="col-sm-10 p-1 pl-2">
                            <input type="checkbox" id="CanStaffCreateTicket" data-plugin="switchery" data-size="small" data-color="#1AB394" data-secondary-color="#ED5565" name="can_staff_create_ticket" <?php if($settings['can_staff_create_ticket']): ?> checked <?php endif; ?> value="1"/>
                            <small class="form-text text-muted">با غیر فعال کردن این گزینه پشتیبانان قادر نخواهند بود برای کاربران تیکت جدیدی ایجاد کنند</small>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="CanUserAttachFileToTicket">امضای تیکت<i class="fa fa-question-circle ml-1" data-toggle="tooltip" title="متنی که در انتهای هر تیکت و پاسخ نمایش داده خواهد شد.هر کاربر میتواند امضای خود را ویرایش کند"></i></label>
                        <div class="col-sm-10 pt-2 pr-0">
                            <div class="custom-control custom-radio custom-control-inline">
                                <input type="radio" id="UsersTicketSignature" name="ticket_signature" class="custom-control-input" value="user" <?php if($settings['ticket_signature'] == 'user'): ?> checked <?php endif; ?>>
                                <label class="custom-control-label" for="UsersTicketSignature">تنها کاربران</label>
                            </div>
                            <div class="custom-control custom-radio custom-control-inline">
                                <input type="radio" id="SuperiorsTicketSignature" name="ticket_signature" class="custom-control-input" value="superior" <?php if($settings['ticket_signature'] == 'superior'): ?> checked <?php endif; ?>>
                                <label class="custom-control-label" for="SuperiorsTicketSignature">تنها پشتیبانان و مدیران</label>
                            </div>
                            <div class="custom-control custom-radio custom-control-inline">
                                <input type="radio" id="AllTicketSignature" name="ticket_signature" class="custom-control-input" value="both" <?php if($settings['ticket_signature'] == 'both'): ?> checked <?php endif; ?>>
                                <label class="custom-control-label" for="AllTicketSignature">همه</label>
                            </div>
                            <div class="custom-control custom-radio custom-control-inline">
                                <input type="radio" id="NoneTicketSignature" name="ticket_signature" class="custom-control-input" value="none" <?php if($settings['ticket_signature'] == 'none'): ?> checked <?php endif; ?>>
                                <label class="custom-control-label" for="NoneTicketSignature">هیچکدام</label>
                            </div>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="MaximumTicketsAttachesCount">تعداد پیوست ها</label>
                        <div class="col-sm-4">
                            <input id="MaximumTicketsAttachesCount" type="text" value="<?php echo e($settings['upload_max_file_count']); ?>" name="upload_max_file_count">
                            <small class="form-text text-muted">حداکثر تعداد فایل هایی که کاربران مجاز هستند به تیکت ها پیوست کنند</small>
                        </div>
                        <div class="col"></div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="MaximumTicketsAttachesSize">حجم پیوست ها</label>
                        <div class="col-sm-4">
                            <input id="MaximumTicketsAttachesSize" type="text" value="<?php echo e($settings['upload_max_file_size']); ?>" name="upload_max_file_size">
                            <small class="form-text text-warning">حداکثر حجم مجاز هر فایل برای آپلود در سرور شما <?php echo ini_get('upload_max_filesize') ?> میباشد </small>
                        </div>
                        <div class="col"></div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="MaximumTicketsAttachesSize">فرمت های مجاز</label>
                        <div class="col-sm-10">
                            <?php $__currentLoopData = array_chunk($fileFormats, 6, true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $format): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="row">
                                    <?php $__currentLoopData = $format; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mime): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-sm-2">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" id="format-<?php echo e($mime); ?>" name="formats[]" value=".<?php echo e($mime); ?>" <?php if(in_array('.'.$mime, $allowedMimes)): ?> checked <?php endif; ?>>
                                                <label class="custom-control-label" for="format-<?php echo e($mime); ?>"><?php echo e(strtoupper($mime)); ?></label>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <div class="clearfix border-top pt-2 border-light">
                        <button class="btn btn-primary float-right" type="submit">ذخیره</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('assets/js/jquery.bootstrap-touchspin.min.js')); ?>"></script>

    <script>
        $("#MaximumTicketsAttachesCount").TouchSpin({
            min: 0,
            max: 10000000000,
            buttondown_class: "btn btn-primary",
            buttonup_class: "btn btn-primary",
            postfix: "تا"
        });
        $("#MaximumTicketsAttachesSize").TouchSpin({
            min: 0,
            max: 1000000000,
            buttondown_class: "btn btn-primary",
            buttonup_class: "btn btn-primary",
            prefix: "MB"
        })
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iphoneun/public_html/peygirsho.ir/patronic/resources/views/panel/settings/ticket.blade.php ENDPATH**/ ?>