@extends('layouts.public-master')
<link rel="shortcut icon" href="{{ asset('assets/images/favicon.ico') }}">
@section('main')
<main class="container mb-5">
    @if(!$news->isEmpty())
    <div class="row" id="sectionLastNews">
        <div class="col-12">
            <div id="lastNewsContainer">
                <ul>
                    @foreach($news as $newsItem)
                        <li {{ $newsItem->id == $news->first()->id ? 'class=active' : '' }}>
                            <a href="{{ route('news.show', $newsItem) }}">{{ $newsItem->title }}</a>
                            @if(\Carbon\Carbon::parse($newsItem->created_at)->diffInHours() < 48)
                            <small class="text-danger align-middle">(جدید)</small>
                            @endif
                        </li>
                    @endforeach
                </ul>
            </div>
            <small>
                <a href="{{ route('news') }}" class="float-left">مشاهده تمامی اخبار</a>
            </small>
        </div>
    </div>
    @endif
    @if(!$faq->isEmpty())
    <div class="row" id="sectionFaq">
        <div class="col-sm-6">
            <div class="accordion" id="activeFaqContainer">
            <!--     <div class="card">
                    <div class="card-header" id="activeFaqHeader">
                        <h2 class="mb-0">
                            <button class="btn btn-link" type="button" data-toggle="collapse" data-target="activeFaqContent" aria-expanded="true" aria-controls="activeFaqContent">
                                {{ $faq->first()->title }}
                            </button>
                        </h2>
                    </div>
               <div id="activeFaqContent" class="collapse show" aria-labelledby="activeFaqHeader" data-parent="#activeFaqContainer">
                        <div class="card-body">
                            {!! clean($faq->first()->content) !!}
                        </div>
                    </div>  
                </div> farshid -->
            </div>
        </div>
        <div class="col-sm-12"> <!-- col-sm-6 -->
            <div class="accordion" id="faqContainer">
            @foreach($faq as $faqItem)
                <div class="card mb-3">
                    <div class="card-header" id="faqHeader{{ $faqItem->id }}">
                        <h2 class="mb-0">
                            <button class="btn btn-link btn-block text-left" type="button" data-toggle="collapse" data-target="#faqContent{{ $faqItem->id }}" aria-expanded="false" aria-controls="faqContent{{ $faqItem->id }}">
                                <span>{{ $faqItem->title }}</span>
                                <span class="fa fa-chevron-down float-left accordion-header-icon"></span>
                            </button>
                        </h2>
                    </div>
                    <div id="faqContent{{ $faqItem->id }}" class="collapse" aria-labelledby="faqHeader{{ $faqItem->id }}" data-parent="#faqContainer">
                        <div class="card-body">
                            {!!  clean($faqItem->content) !!}
                        </div>
                    </div>
                </div>
                @endforeach
            <small><a href="{{ route('faqs') }}" class="float-left m-3 mr-1">تمامی سوالات متداول</a></small>
            </div>
        </div>
    </div>
    @endif
    @if($templateConfigs['showOurTeamSection'])
    <div id="sectionOurTeam">
        <h4 class="default-color text-center mb-5">
            <span class="fa fa-users d-block mb-3 font-lg"></span>
            <span>{{ $templateConfigs['ourTeamHeader'] }}</span>
        </h4>
        <div class="row">
            @foreach($templateConfigs['teamMembers'] as $teamMember)
            @if($teamMember['name'])
            <div class="col-sm-4">
                <div class="team-member mb-2">
                    <div class="team-member-header text-center">
                        <img src="{{ isset($teamMember['avatar']) ? asset('files/' . $teamMember['avatar']) : asset('assets/images/default-avatar.png') }}" alt="avatar" width="80" class="rounded-circle"/>
                        <h6 class="mt-3">
                            <span class="team-member-name">{{ $teamMember['name'] }}</span>
                            <span>{{ $teamMember['position'] }}</span>
                        </h6>
                    </div>
                    <div class="team-member-about text-justify text-muted">
                        {{ $teamMember['bio'] }}
                    </div>
                    <div class="team-member-social clearfix">
                        <ul class="list-unstyled p-0">
                            <li class="float-left pr-2"><a href="{{ $teamMember['instagram'] ?: '#' }}" class="text-muted"><span class="fab fa-instagram"></span></a></li>
                            <li class="float-left pr-2"><a href="{{ $teamMember['twitter'] ?: '#' }}" class="text-muted"><span class="fab fa-twitter"></span></a></li>
                            <li class="float-left pr-2"><a href="{{ $teamMember['telegram'] ?: '#' }}" class="text-muted"><span class="fab fa-telegram"></span></a></li>
                            <li class="float-left pr-2"><a href="{{ $teamMember['linkedin'] ?: '#' }}" class="text-muted"><span class="fab fa-linkedin"></span></a></li>
                        </ul>
                    </div>
                </div>
            </div>
            @endif
            @endforeach
        </div>
    </div>
    @endif
</main>
@endsection