$(document).ready(function () {
    var swal = Swal.mixin({
        confirmButtonText: 'باشه'
    });

    $.ajaxSetup({
        'headers': {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $('html').on('click', 'td [data-delete-url]', function () {
        var elem = $(this);
        swal.fire({
            title: 'آیا از حذف اطلاعات اطمینان دارید؟',
            text: "مورد انتخاب شده حذف خواهد شد و این عمل قابل بازگردانی نخواهد بود!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'حذف کن',
            cancelButtonText: 'انصراف',
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: elem.attr('data-delete-url'),
                    type: 'DELETE',
                    dataType: 'json',
                    error: function (error) {
                        if (error.hasOwnProperty('responseJSON')) {
                            if (error.responseJSON.message !== '') {
                                swal.fire('انجام نشد', error.responseJSON.message, 'error')
                            }
                        }
                    },
                    success: function (response) {
                        if (response.status === 'success') {
                            elem.parents('tr').addClass('table-danger').fadeOut();
                        } else if (response.status === 'fail') {
                            swal.fire('انجام نشد', 'مشکلی در حذف بوجود آمده است', 'error')
                        } else {
                            swal.fire('انجام نشد', 'مشکلی در حذف بوجود آمده است', 'error')
                        }
                    }
                });
            }
        })
    });

    $('[data-close-ticket]').click(function () {
        var elem = $(this);
        swal.fire({
            title: 'آیا از بستن تیکت اطمینان دارید؟',
            text: "تیکت بسته خواهد شد و پشتیبانان امکان ارسال پاسخ به این تیکت را نخواهند داشت",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'تیکت را ببند',
            cancelButtonText: 'انصراف',
        }).then((result) => {
            if (result.value) {
                elem.attr('disabled', 'disabled').html('<span class="spinner-border spinner-border-sm mr-1" role="status" aria-hidden="true"></span>در حال پردازش...');
                $.ajax({
                    url: elem.attr('data-close-ticket'),
                    type: 'PATCH',
                    dataType: 'json',
                    error: function (error) {
                        if (error.hasOwnProperty('responseJSON')) {
                            if (error.responseJSON.message !== '') {
                                swal.fire('انجام نشد', error.responseJSON.message, 'error')
                            }
                        }
                    },
                    success: function (response) {
                        if (response.status === 'success') {
                            swal.fire('انجام شد', 'وضعیت تیکت با موفقیت به بسته تغییر پیدا کرد', 'success');
                            window.setTimeout(function () {
                                window.location.reload();
                            }, 1000);
                        } else if (response.status === 'fail') {
                            swal.fire('انجام نشد', 'مشکلی در بستن تیکت بوجود آمده است', 'error')
                        } else {
                            swal.fire('انجام نشد', 'مشکلی در بستن تیکت بوجود آمده است', 'error')
                        }
                    },
                    complete: function () {
                        elem.removeAttr('disabled').html('بستن تیکت');
                    }
                });
            }
        })
    });

    $('[data-reopen-ticket]').click(function () {
        var elem = $(this);
        swal.fire({
            title: 'آیا از بازگشایی تیکت اطمینان دارید؟',
            text: "تیکت مجددا به حالت عادی بازگشته و پشتیبانان امکان ارسال پاسخ به این تیکت را خواهند داشت",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'تیکت را باز کن',
            cancelButtonText: 'انصراف',
        }).then((result) => {
            if (result.value) {
                elem.attr('disabled', 'disabled').html('<span class="spinner-border spinner-border-sm mr-1" role="status" aria-hidden="true"></span>در حال پردازش...');
                $.ajax({
                    url: elem.attr('data-reopen-ticket'),
                    type: 'PATCH',
                    dataType: 'json',
                    error: function (error) {
                        if (error.hasOwnProperty('responseJSON')) {
                            if (error.responseJSON.message !== '') {
                                swal.fire('انجام نشد', error.responseJSON.message, 'error')
                            }
                        }
                    },
                    success: function (response) {
                        if (response.status === 'success') {
                            swal.fire('انجام شد', 'وضعیت تیکت به حالت باز تغییر پیدا کرد', 'success');
                            window.setTimeout(function () {
                                window.location.reload();
                            }, 1000);
                        } else if (response.status === 'fail') {
                            swal.fire('انجام نشد', 'مشکلی در بازگشایی تیکت بوجود آمده است', 'error')
                        } else {
                            swal.fire('انجام نشد', 'مشکلی در بازگشایی تیکت بوجود آمده است', 'error')
                        }
                    },
                    complete: function () {
                        elem.removeAttr('disabled').html('بازگشایی تیکت');
                    }
                });
            }
        })
    });

    $('#DepartmentsList').change(function () {
        var elem = $(this);
        elem.attr('disabled', 'disabled');
        $.ajax({
            url: elem.attr('data-refer-ticket'),
            data: {department: elem.val()},
            type: 'PATCH',
            dataType: 'json',
            error: function (error) {
                if (error.hasOwnProperty('responseJSON')) {
                    if (error.responseJSON.message !== '') {
                        swal.fire('انجام نشد', error.responseJSON.message, 'error')
                    }
                }
            },
            success: function (response) {
                if (response.status === 'success') {
                    swal.fire('انجام شد', response.msg, 'success');
                    window.setTimeout(function () {
                        window.location.reload();
                    }, 1000);
                } else if (response.status === 'fail') {
                    swal.fire('انجام نشد', 'مشکلی در ارجاع تیکت بوجود آمده است', 'error')
                } else {
                    swal.fire('انجام نشد', 'مشکلی در ارجاع تیکت بوجود آمده است', 'error')
                }
            },
            complete: function () {
                elem.removeAttr('disabled');
            }
        });
    });

    $('.star-rating.rated').starRating({
        readOnly: true,
        totalStars: 5,
        starShape: 'rounded',
        starSize: 20,
        emptyColor: 'lightgray',
        hoverColor: 'salmon',
        activeColor: 'crimson',
        useGradient: false
    });

    $('.star-rating').starRating({
        totalStars: 5,
        starShape: 'rounded',
        starSize: 20,
        emptyColor: 'lightgray',
        hoverColor: 'salmon',
        activeColor: 'crimson',
        useGradient: false,
        callback: function (rate, $elem) {
            $elem.after('<small class="fa fa-spin fa-spinner adding-rate"></small>');
            $.post($elem.attr('data-rate-reply'), {rate: rate}, function (response) {
                if (response.hasOwnProperty('status') && response.status === 'success') {
                    window.setTimeout(function () {
                        $('body').find('.adding-rate').hide();
                        $($elem).after('<small class="text-success">امتیاز شما ثبت شد</small>');
                    }, 1500)
                } else alert('ثبت نشد');
            }, 'json');
        }
    });

    $('[data-ajax-form]').submit(function (e) {
        e.preventDefault();
        var form = $(this);
        var result = form.find('.result');
        var subbtn = form.find(':submit');
        subbtn.attr('disabled', 'disabled').html('<span class="spinner-border spinner-border-sm mr-1" role="status" aria-hidden="true"></span>در حال پردازش...');
        result.fadeOut();
        $.ajax({
            url: form.attr('action'),
            type: form.attr('method'),
            dataType: 'json',
            data: form.serialize(),
            error: function (error) {
                if (error.hasOwnProperty('responseJSON')) {
                    if (error.responseJSON.message !== '') {
                        $('.result').addClass('alert-danger').removeClass('alert-success').html(error.responseJSON.message)
                    }
                }
            },
            success: function (response) {
                if (response.status === 'success') {
                    result.addClass('alert-success').removeClass('alert-danger').html(response.msg);
                    var attr = form.attr('data-redirect-url');
                    if (typeof attr !== typeof undefined && attr !== false) {
                        window.setTimeout(function () {
                            window.location.href = form.attr('data-redirect-url');
                        }, 800);
                    }
                } else if (response.status === 'fail') {
                    result.addClass('alert-danger').removeClass('alert-success').html(response.msg);
                } else {
                    result.addClass('alert-danger').removeClass('alert-success').html('خطایی بوجود آمده است');
                }
            },
            complete: function () {
                result.fadeIn();
                subbtn.removeAttr('disabled').html('ذخیره');
            }
        })
    });


    $('[data-filter-status]').click(function () {
        $(this).toggleClass('active');
        $('tr[data-status=' + $(this).attr('data-filter-status') + ']').toggle();
        if ($(this).attr('data-filter-status') == 'closed') {
            $('tr[data-is-closed=1]').toggle();
        }
    });

    $('[data-report-reply]').click(function (e) {
        e.preventDefault();
        $('#replyId').val($(this).attr('data-report-reply'));
    });

    $('#addReplyBtn').click(function () {
        if ($(this).attr('aria-expanded') === 'false') {
            $('body,html').animate({
                scrollTop: 350
            }, 1200);
        }
    });

});
