<?php

namespace App\Notifications\Tickets;

use App\Ticket;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\BroadcastMessage;
use Illuminate\Notifications\Notification;

class Created extends Notification
{
    use Queueable;

    public $ticket;

    /**
     * Create a new notification instance.
     *
     * @param Ticket $ticket
     */
    public function __construct(Ticket $ticket)
    {
        $this->ticket = $ticket;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['database'];
    }

    /**
     * Get the array representation of the notification.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'title' => 'تیکت جدیدی دریافت شد',
            'text' => 'تیکت جدیدی با موضوع ' . $this->ticket->subject . ' دریافت شد ',
            'url' => route('panel.tickets.show', $this->ticket)
        ];
    }

    public function toBroadcast($notifiable)
    {
        return new BroadcastMessage([
            'data' => [
                'title' => 'تیکت جدیدی دریافت شد',
                'text' => 'تیکت جدیدی با موضوع ' . $this->ticket->subject . ' دریافت شد ',
                'url' => route('panel.tickets.show', $this->ticket)
            ]
        ]);
    }
}
