<?php

namespace App\Mail;

use App\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class UserActivationMail extends Mailable
{
    use Queueable;
    use SerializesModels;

    public $user;
    public $verificationToken;
    public $verificationId;

    /**
     * Create a new message instance.
     *
     * @param User $user
     * @param $verificationToken
     * @param $verificationId
     */
    public function __construct(User $user, $verificationToken, $verificationId)
    {
        $this->user = $user;
        $this->verificationToken = $verificationToken;
        $this->verificationId = $verificationId;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject("تایید حساب کاربری" . '[' . config('site_title', config('app.name')) . ']')->markdown('emails.user.registered');
    }
}
