<?php

use Illuminate\Http\JsonResponse;
use Symfony\Component\HttpFoundation\Response;

function getConfig($configName)
{
    if ($configName) {
        $config = \App\Setting::where('config_name', $configName)->first();
        if ($config) {
            return $config->config_value;
        }
    }
    return null;
}

function user_status_label($userStatus): string
{
    switch ($userStatus) {
        case 'active':
            return '<label class="badge label-table badge-light-success">فعال</label>';
        case 'disabled':
            return '<label class="badge label-table badge-light-secondary">غیر فعال</label>';
        case 'banned':
            return '<label class="badge label-table badge-light-danger">مسدود شده</label>';
        default:
            return '<label class="badge label-table badge-light-warning">نامشخص</label>';
    }
}

function department_status_label($departmentIsHidden): string
{
    if ($departmentIsHidden) {
        return '<label class="badge label-table badge-light-secondary">مخفی</label>';
    }
    return '<label class="badge label-table badge-light-success">عمومی</label>';
}

function ticket_priority_label($ticketPriority): string
{
    switch ($ticketPriority) {
        case 1:
            return '<label class="badge label-table badge-light-dark">کم اهمیت</label>';
        case 2:
            return '<label class="badge label-table badge-light-primary">متوسط</label>';
        case 3:
            return '<label class="badge label-table badge-light-warning">ضروری</label>';
        case 4:
            return '<label class="badge label-table badge-light-danger">بحرانی</label>';
        default:
            return '<label class="badge label-table badge-light-warning">نامشخص</label>';
    }
}

function ticket_priority($ticketPriority): string
{
    switch ($ticketPriority) {
        case 1:
            return 'کم اهمیت';
        case 2:
            return 'متوسط';
        case 3:
            return 'ضروری';
        case 4:
            return 'بحرانی';
        default:
            return 'نامشخص';
    }
}

function ticket_status_color($ticketStatus): string
{
    switch ($ticketStatus) {
        case 'unread':
            return 'table-warning';
        case 'read':
            return 'bg-light';
        case 'replied':
            return 'table-primary';
        case 'replied_pv':
            return 'table-purple';
        case 'referred':
            return 'table-dark';
    }
}

function ticket_status_class($ticketStatus): string
{
    switch ($ticketStatus) {
        case 'unread':
            return 'warning';
        case 'read':
            return 'secondary';
        case 'replied':
            return 'primary';
        case 'replied_pv':
            return 'purple';
        case 'pending':
            return 'info';
        case 'referred':
            return 'dark';
        default:
            return 'gray';
    }
}

function ticket_status($ticketStatus): string
{
    switch ($ticketStatus) {
        case 'read':
            return 'خوانده شده';
        case 'unread':
            return 'خوانده نشده';
        case 'replied':
            return 'پاسخ داده شده';
        case 'replied_pv':
            return 'پاسخ محرمانه';
        case 'referred':
            return 'ارجاع داده شده';
        default:
            return 'نامشخص';
    }
}

function post_type_label($postType): string
{
    switch ($postType) {
        case 'news':
            return 'اخبار';
        case 'faq':
            return 'سوالات متداول';
    }
}

function post_status_label($postStatus): string
{
    switch ($postStatus) {
        case 'public':
            return '<label class="badge badge-light-primary">در حال نمایش</label>';
        case 'draft':
            return '<label class="badge badge-light-secondary">پیش نویس</label>';
    }
}

function updateDotEnv($key, $newValue, $delim = '"')
{
    throw_if($key !== 'APP_LICENSE_KEY' and \Illuminate\Support\Str::contains($newValue, ['"', '\'', '=']), new Exception(__('Invalid characters for env value.')));

    $path = base_path('.env');
    $oldValue = env($key);

    if ($oldValue === true or $oldValue === false) {
        $oldValue = $oldValue ? 'true' : 'false';
    }

    if ($oldValue === $newValue) {
        return;
    }

    if (file_exists($path)) {
        file_put_contents(
            $path,
            str_replace(
                [$key . '=' . $delim . $oldValue . $delim],
                $key . '=' . $delim . $newValue . $delim,
                file_get_contents($path)
            )
        );
    }
}

function sms(): \Plugins\Sms\SmsBuilder
{
    return app('patronic-sms');
}

function pluginsPath(): string
{
    return __DIR__ . '/../plugins';
}