<?php

namespace App\Notifications\Tickets;

use App\Channels\SmsChannel;
use App\Reply;
use App\Ticket;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\BroadcastMessage;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Illuminate\Support\Facades\Mail;

class SuperiorReplied extends Notification
{
    use Queueable;

    public $ticket;
    public $reply;

    /**
     * Create a new notification instance.
     *
     * @param Ticket $ticket
     * @param Reply $reply
     */
    public function __construct(Ticket $ticket, Reply $reply)
    {
        $this->ticket = $ticket;
        $this->reply = $reply;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return config('email_notifications', false) ?
            ['database', SmsChannel::class, 'mail'] :
            ['database', SmsChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param mixed $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage())
            ->subject("تیکت شما پاسخ داده شد" . '[' . config('site_title', env('APP_NAME')) . ']')
            ->markdown('emails.tickets.replied-by-superior', ['ticket' => $this->ticket, 'reply' => $this->reply]);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param mixed $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'title' => 'تیکت پاسخ داده شد',
            'text' => 'تیکت شما با موضوع ' . $this->ticket->subject . ' پاسخ داده شد ',
            'url' => route('panel.tickets.show', $this->ticket) . '#reply-' . $this->reply->id
        ];
    }

    public function toBroadcast($notifiable)
    {
        return new BroadcastMessage([
            'data' => [
                'title' => 'تیکت پاسخ داده شد',
                'text' => 'تیکت شما با موضوع ' . $this->ticket->subject . ' پاسخ داده شد ',
                'url' => route('panel.tickets.show', $this->ticket) . '#reply-' . $this->reply->id
            ]
        ]);
    }

    public function toSms($notifiable)
    {
        return 'تیکت شما با موضوع ' . $this->ticket->subject . ' پاسخ داده شد ';
    }
}
