@extends('layouts.user-panel.master')

@section('breadcrumb')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <h4 class="page-title">پنل کاربری</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')
    <div class="row">
        <div class="col">
            <div class="card-box">
                <div class="clearfix">
                    <div class="float-left">
                        <h4 class="header-title">تیکت ها</h4>
                        <p class="sub-header">لیست آخرین تیکت های ثبت شده</p>
                    </div>
                    <a href="{{ route('panel.tickets.create') }}" class="btn btn-primary float-right"><i class="remixicon-chat-4-line align-middle"></i> ارسال تیکت جدید </a>
                </div>
                @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                <div class="w-50 mb-3 mx-auto text-center">
                    <span class="badge badge-warning active" data-filter-status="unread">خوانده نشده</span>
                    <span class="badge badge-light active" data-filter-status="read">خوانده شده</span>
                    <span class="badge badge-primary active" data-filter-status="replied">پاسخ داده شده</span>
                    <span class="badge badge-dark active" data-filter-status="referred">ارجاع داده شده</span>
                    <span class="badge badge-danger active" data-filter-status="closed">بسته</span>
                </div>
                <div class="table-responsive">
                    <table class="table table-bordered text-center table-centered">
                        <thead class="thead-light">
                        <tr>
                            <th>#</th>
                            <th>عنوان</th>
                            <th>اولویت</th>
                            <th>دپارتمان</th>
                            <th>تاریخ</th>
                            <th>گزینه ها</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($tickets as $ticket)
                            <tr data-status="{{ $ticket->status != 'replied_pv' ? $ticket->status : 'read' }}" data-is-closed="{{ $ticket->isClosed() }}">
                                <td class="{{ $ticket->status != 'replied_pv' ? ticket_status_color($ticket->status) : 'bg-light' }} @if($ticket->isClosed()) table-danger @endif">{{ $ticket->id }}</td>
                                <td><a href="{{ route('panel.tickets.show', $ticket) }}" @if($ticket->status == 'replied') class="font-weight-bold" @endif>{{ $ticket->subject }}</a></td>
                                <td>{!! ticket_priority_label($ticket->priority) !!}</td>
                                <td>{{ $ticket->department->name }}</td>
                                <td title="@jalali($ticket->created_at)" data-toggle="tooltip">@jalali($ticket->created_at,true)</td>
                                <td>
                                    <div class="btn-group dropdown">
                                        <a href="javascript: void(0);" class="dropdown-toggle arrow-none btn btn-light btn-sm" data-toggle="dropdown" aria-expanded="false"><i class="mdi mdi-dots-horizontal"></i></a>
                                        <div class="dropdown-menu dropdown-menu-right" x-placement="bottom-end" style="position: absolute; will-change: transform; top: 0px; left: 0px; transform: translate3d(39px, 29px, 0px);">
                                            @if(!$ticket->isClosed() and config('can_user_close_ticket'))
                                                <a class="dropdown-item" href="#" data-close-ticket="{{ route('panel.tickets.close', $ticket) }}">بستن تیکت<i class="mdi mdi-minus-circle-outline mr-2 text-muted font-18 align-middle"></i></a>
                                            @elseif($ticket->isClosed() and config('can_user_reopen_ticket'))
                                                <a class="dropdown-item" href="#" data-reopen-ticket="{{ route('panel.tickets.reopen', $ticket) }}">بازگشایی تیکت<i class="remixicon-chat-check-line mr-2 text-muted font-18 align-middle"></i></a>
                                            @endif
                                            <a class="dropdown-item" href="#" data-delete-url="{{ route('panel.tickets.destroy', $ticket) }}">حذف تیکت<i class="mdi mdi-close-outline mr-2 font-18 text-muted align-middle"></i></a>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <td colspan="6" class="bg-light text-muted text-center">داده ای یافت نشد</td>
                        @endforelse
                        </tbody>
                    </table>
                </div>
                {{ $tickets->links() }}
            </div>
        </div><!-- end col -->

    </div>
    <!-- end row -->
@endsection