<?php

const MELLIPAYAMAK_SMS_DRIVER = 'mellipayamak';
const IPPANEL_SMS_DRIVER = 'ippanel';
const FOOD_SMS_DRIVER = 'foodsms';
const KAVEH_NEGAR_SMS_DRIVER = 'kavehnegar';
const SUNWAY_SMS_DRIVER = 'sunwaysms';

return [
    'default' => 'mellipayamak',

    'drivers' => [
        MELLIPAYAMAK_SMS_DRIVER => [
            'name' => 'ملی پیامک',
            'settings_file' => 'Sms.Drivers.MelliPayamak.settings'
        ],
        IPPANEL_SMS_DRIVER => [
            'name' => 'ippanel',
            'settings_file' => 'Sms.Drivers.Ippanel.settings'
        ],
        FOOD_SMS_DRIVER => [
            'name' => 'foodsms',
            'settings_file' => 'Sms.Drivers.FoodSms.settings'
        ],
        KAVEH_NEGAR_SMS_DRIVER => [
            'name' => 'کاوه نگار',
            'settings_file' => 'Sms.Drivers.KavehNegar.settings'
        ],
        SUNWAY_SMS_DRIVER => [
            'name' => 'sunwaysms',
            'settings_file' => 'Sms.Drivers.SunwaySms.settings'
        ],
    ],

    'map' => [
        MELLIPAYAMAK_SMS_DRIVER => \Plugins\Sms\Drivers\MelliPayamak\MelliPayamakSmsDriver::class,
        IPPANEL_SMS_DRIVER => \Plugins\Sms\Drivers\Ippanel\SunwaySmsDriver::class,
        FOOD_SMS_DRIVER => \Plugins\Sms\Drivers\FoodSms\FoodSmsDriver::class,
        KAVEH_NEGAR_SMS_DRIVER => \Plugins\Sms\Drivers\KavehNegar\KavehNegarSmsDriver::class,
    ]
];
