<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array
     */
    protected $policies = [
        // 'App\Model' => 'App\Policies\ModelPolicy',
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();

        Gate::define('manage-settings', function () {
            if (auth()->user()->isAdmin()) {
                return true;
            }
            return false;
        });

        Gate::define('quick-access', function () {
            if (auth()->user()->isAdmin()) {
                return true;
            }
            return false;
        });

        Gate::define('view-dashboard', function () {
            if (auth()->user()->isAdmin()) {
                return true;
            }
            return false;
        });
    }
}
