<?php

namespace App;

use Spatie\MediaLibrary\Models\Media;
use Spatie\MediaLibrary\PathGenerator\PathGenerator;

class MediaLibraryCustomPathGenerator implements PathGenerator
{

    public function getPath(Media $media): string
    {
        return $media->collection_name . '/' . $media->model_id . '/';
    }

    public function getPathForConversions(Media $media): string
    {
        return $media->collection_name . '/' . $media->model_id . '/c/';
    }

    public function getPathForResponsiveImages(Media $media): string
    {
        return $media->collection_name . '/' . $media->model_id . '/responsive/';
    }
}
