
<?php $__env->startSection('title', 'مشاهده تیکت'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('panel.tickets.index')); ?>">تیکت ها</a></li>
                        <li class="breadcrumb-item active">مشاهده تیکت</li>
                    </ol>
                </div>
                <h4 class="page-title"><?php echo e($ticket->subject); ?></h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col">
            <table class="table table-centered table-responsive-sm table-light mb-0 table-bordered">
                <tbody>
                <tr>
                    <td>شماره: <?php echo e($ticket->id); ?></td>
                    <td>اولویت: <?php echo ticket_priority_label($ticket->priority); ?></td>
                    <td>دپارتمان: <?php echo e($ticket->department->name); ?></td>
                    <td>آخرین وضعیت: <?php if(!$ticket->isClosed()): ?>
                            <span class="text-<?php echo e(ticket_status_class($ticket->status)); ?>"><?php echo e(ticket_status($ticket->status)); ?></span>
                        <?php else: ?>
                            <span class="text-danger">بسته</span>
                        <?php endif; ?></td>
                    <td><?php if($ticket->isReplied()): ?>
                            <span class="text-muted">آخرین پاسخ </span>
                            <span title="<?php echo jdate($ticket->replies->first()->created_at)->format('H:i:s Y/m/d'); ?>" data-toggle="tooltip"><?php echo jdate($ticket->replies->first()->created_at)->ago(); ?></span>
                            <span class="text-muted">توسط </span>
                            <span><?php echo e(\App\User::find($ticket->replies->first()->replied_by)->name); ?></span>
                        <?php else: ?>
                            <small class="text-muted">بدون پاسخ</small>
                        <?php endif; ?>
                    </td>
                </tr>
                </tbody>
            </table>
            <div class="card border-0 shadow-sm d-flex flex-row" style="border-top-right-radius: 0;border-top-left-radius: 0; ">
                <div class="ticket-body ml-1 w-100">
                    <div class="clearfix mb-2">
                        <div class="float-left">
                            <img class="rounded-circle mr-1"
                                 src="<?php echo e($ticket->user->getFirstMediaUrl('avatar') ? url($ticket->user->getFirstMediaUrl('avatar')) : asset('assets/images/default-avatar.png')); ?>"
                                 width="30" alt="تصویر پروفایل">
                            <h5 class="mt-0 d-inline-block">
                                <span><?php echo e($ticket->user->name); ?></span>
                                <small class="text-muted" title="<?php echo jdate($ticket->created_at)->format('H:i:s Y/m/d'); ?>" data-toggle="tooltip">(<?php echo jdate($ticket->created_at)->ago(); ?>)</small>
                            </h5>
                        </div>
                        <div class="clearfix mb-1">
                            <?php if((auth()->user()->isUser() and config('can_user_change_department')) or !auth()->user()->isUser()): ?>
                                <select id="DepartmentsList" class="custom-select custom-select-sm float-right ml-1" style="width: auto"
                                        data-refer-ticket="<?php echo e(route('panel.tickets.refer', $ticket)); ?>">
                                    <option value="0" selected disabled>ارجاع به دپارتمان</option>
                                    <?php $__currentLoopData = \App\Department::all()->except($ticket->department->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($department->id); ?>"><?php echo e($department->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            <?php endif; ?>
                            <?php if($ticket->isClosed() and ((auth()->user()->isUser() and config('can_user_reopen_ticket')) or (!auth()->user()->isUser()))): ?>
                                <button class="btn btn-sm btn-success float-right ml-1"
                                        data-reopen-ticket="<?php echo e(route('panel.tickets.reopen', $ticket)); ?>">بازگشایی تیکت
                                </button>
                            <?php elseif((!$ticket->isClosed() and (auth()->user()->isUser() and config('can_user_close_ticket')) or (!auth()->user()->isUser()))): ?>
                                <button class="btn btn-sm btn-danger float-right ml-1"
                                        data-close-ticket="<?php echo e(route('panel.tickets.close', $ticket)); ?>">بستن تیکت
                                </button>
                            <?php endif; ?>
                            <a class="float-right text-danger mt-1" href="javascript:void(0)" data-toggle="modal" data-target="#reportTicketModal">
                                <span>گزارش</span>&nbsp;<i class="mdi mdi-alert-circle-outline align-top"></i>
                            </a>
                        </div>
                    </div>
                    <?php echo clean(nl2br($ticket->content)); ?>

                    <?php if(!$ticket->getMedia('attach')->isEmpty()): ?>
                        <div class="ticket-attaches">
                            <div class="btn-group">
                                <a class="btn btn-light btn-sm dropdown-toggle" href="#" type="button" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    پیوست ها
                                    <i class="remixicon-download-2-line mr-1 align-middle"></i>
                                </a>
                                <div class="dropdown-menu">
                                    <?php if($ticket->getMedia('attach')->count() > 1): ?>
                                        <a class="dropdown-item" href="<?php echo e(route('panel.tickets.attach.all', $ticket)); ?>">دانلود همه<i class="remixicon-file-zip-line mr-1 align-middle"></i></a>
                                        <div class="dropdown-divider"></div>
                                    <?php endif; ?>
                                    <?php $__currentLoopData = $ticket->getMedia('attach'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a class="dropdown-item" href="<?php echo e(route('panel.tickets.attach.download',[$ticket, $media])); ?>" data-toggle="tooltip" title="<?php echo e($media->file_name); ?>"> پیوست شماره <?php echo e($loop->index + 1); ?><i class="remixicon-file-download-line  mr-1 align-middle"></i></a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <small class="text-muted">بدون پیوست</small>
                    <?php endif; ?>
                </div>
            </div>
        </div><!-- end col -->
    </div>

    <?php if(!$ticket->isClosed() or ($ticket->isClosed() and !auth()->user()->isUser())): ?>
        <div id="addReplyContainer" class="collapse show">
            <div class="card card-box">
                <h5 class="text-muted card-title">ارسال پاسخ یا
                    <button class="btn btn-xs btn-secondary" data-toggle="modal" data-target="#quickResponsesModal">انتخاب از پاسخ‌های آماده</button>
                </h5>
                <form action="<?php echo e(route('panel.tickets.reply', $ticket)); ?>" method="post" id="addReplyForm" data-parsley-validate data-ajax-form data-redirect-url="<?php echo e(route('panel.tickets.show', $ticket)); ?>">
                    <div class="form-group">
                        <textarea name="text" id="ReplyText" class="form-control" cols="30" rows="6" placeholder="متن پاسخ را وارد کنید..." required></textarea>
                    </div>
                    <div class="form-group">
                        <div class="result alert" style="display: none"></div>
                    </div>
                    <div class="from-group">
                        <button class="btn btn-bordered-success float-right ml-1" type="submit">ذخیره</button>
                        <?php if((auth()->user()->isUser() and config('can_user_attach_file')) or !auth()->user()->isUser()): ?>
                            <button class="btn btn-bordered-secondary float-right" type="button" data-toggle="modal" data-target="#addFileToTicketModal">
                                <span>افزودن فایل</span>
                                (<span class="files-count">0</span>)
                            </button>
                        <?php endif; ?>
                        <?php if(auth()->user()->isSuperior()): ?>
                            <div class="checkbox checkbox-primary">
                                <input id="isPrivate" type="checkbox" name="is_private" value="1">
                                <label for="isPrivate">
                                    پاسخ محرمانه
                                </label>
                                <small data-toggle="tooltip" title="با فعال کردن این گزینه پاسخ شما تنها برای پشتیبانان و مدیریت قابل مشاهده خواهد و کاربر پاسخ محرمانه را دریافت و مشاهده نخواهد کرد"><i class="fa fa-question-circle"></i></small>
                            </div>
                        <?php endif; ?>
                    </div>
                </form>
            </div>
        </div>
    <?php endif; ?>

    <?php $__currentLoopData = $ticket->replies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reply): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="row">
            <div class="col">
                <?php if($reply->isUserReply()): ?>
                    <div class="card p-3" id="reply-<?php echo e($reply->id); ?>">
                        <div class="reply-header clearfix">
                            <h5 class="text-muted card-title float-left">
                                <img class="rounded-circle mr-1" src="<?php echo e($reply->user->getFirstMediaUrl('avatar') ? url($reply->user->getFirstMediaUrl('avatar')) : asset('assets/images/default-avatar.png')); ?>" alt="تصویر پروفایل" width="30">
                                <?php echo e($reply->user->name); ?> <span class="font-13" data-toggle="tooltip" title="<?php echo jdate($reply->created_at)->format('H:i:s Y/m/d'); ?>">(<?php echo jdate($reply->created_at)->ago(); ?>)</span>
                            </h5>
                            <small class="float-right">
                                <a class="text-danger" href="javascript:void(0)" data-toggle="modal" data-target="#reportTicketModal" data-report-reply="<?php echo e($reply->id); ?>">
                                    <span>گزارش</span>&nbsp;
                                    <i class="mdi mdi-alert-circle-outline align-top"></i>
                                </a>
                            </small>
                        </div>
                        <div class="reply-content"><?php echo clean(nl2br($reply->content)); ?></div>
                        <?php if(!$reply->getMedia('attach')->isEmpty()): ?>
                            <div class="ticket-attaches">
                                <div class="btn-group">
                                    <a class="btn btn-light btn-sm dropdown-toggle" href="#" type="button" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        پیوست ها
                                        <i class="remixicon-download-2-line mr-1 align-middle"></i>
                                    </a>
                                    <div class="dropdown-menu">
                                        <?php if($reply->getMedia('attach')->count() > 1): ?>
                                            <a class="dropdown-item" href="<?php echo e(route('panel.tickets.attach.all', $ticket)); ?>">دانلود همه<i class="remixicon-file-zip-line mr-1 align-middle"></i></a>
                                            <div class="dropdown-divider"></div>
                                        <?php endif; ?>
                                        <?php $__currentLoopData = $reply->getMedia('attach'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a class="dropdown-item" href="<?php echo e(route('panel.tickets.attach.download',[$ticket, $media])); ?>" data-toggle="tooltip" title="<?php echo e($media->file_name); ?>"> پیوست شماره <?php echo e($loop->index + 1); ?><i class="remixicon-file-download-line  mr-1 align-middle"></i></a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if((config('ticket_signature') == 'user' or config('ticket_signature') == 'both') and $reply->user->signature): ?>
                            <div class="signature">
                                <?php echo clean(nl2br($reply->user->signature)); ?>

                            </div>
                        <?php endif; ?>
                    </div>
                <?php else: ?>
                    <div class="card p-2 admin-reply" id="reply-<?php echo e($reply->id); ?>">
                        <div class="reply-header mb-2">
                            <div class="clearfix">
                                <h5 class="text-muted card-title mb-1 float-left">
                                    <img class="rounded-circle mr-1" src="<?php echo e($reply->user->getFirstMediaUrl('avatar') ? url($reply->user->getFirstMediaUrl('avatar')) : asset('assets/images/default-avatar.png')); ?>" alt="تصویر پروفایل" width="30">
                                    <?php echo e($reply->user->name); ?>

                                    <?php if($reply->user->isSuperiorStaff()): ?>
                                        <span class="text-warning" data-toggle="tooltip" title="پشتیبان برتر">
                                        <i class="remixicon-award-fill"></i>
                                    </span>
                                    <?php endif; ?>
                                    <span class="font-13" data-toggle="tooltip" title="<?php echo jdate($reply->created_at)->format('H:i:s Y/m/d'); ?>">(<?php echo jdate($reply->created_at)->ago(); ?>)</span>
                                </h5>
                                <small class="float-right">
                                    <a class="text-danger" href="javascript:void(0)" data-toggle="modal" data-target="#reportTicketModal" data-report-reply="<?php echo e($reply->id); ?>">
                                        <span>گزارش</span>&nbsp;
                                        <i class="mdi mdi-alert-circle-outline align-top"></i>
                                    </a>
                                </small>
                            </div>
                            <div class="star-rating <?php if($reply->isRated() or !auth()->user()->isUser()): ?> rated <?php endif; ?>" <?php if(!$reply->isRated()): ?> data-rate-reply="<?php echo e(route('panel.replies.rate', $reply)); ?>" <?php else: ?> data-rating="<?php echo e($reply->rate); ?>" <?php endif; ?>></div>
                        </div>
                        <?php if($reply->is_private): ?>
                            <small class="text-pink">* این پاسخ به صورت محرمانه ارسال شده است</small>
                        <?php endif; ?>
                        <div class="reply-content"><?php echo clean(nl2br($reply->content)); ?></div>
                        <?php if(!$reply->getMedia('attach')->isEmpty()): ?>
                            <div class="ticket-attaches">
                                <div class="btn-group">
                                    <a class="btn btn-light btn-sm dropdown-toggle" href="#" type="button" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        پیوست ها
                                        <i class="remixicon-download-2-line mr-1 align-middle"></i>
                                    </a>
                                    <div class="dropdown-menu">
                                        <?php if($reply->getMedia('attach')->count() > 1): ?>
                                            <a class="dropdown-item" href="<?php echo e(route('panel.tickets.attach.all', $ticket)); ?>">دانلود همه<i class="remixicon-file-zip-line mr-1 align-middle"></i></a>
                                            <div class="dropdown-divider"></div>
                                        <?php endif; ?>
                                        <?php $__currentLoopData = $reply->getMedia('attach'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $media): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a class="dropdown-item" href="<?php echo e(route('panel.tickets.attach.download',[$ticket, $media])); ?>" data-toggle="tooltip" title="<?php echo e($media->file_name); ?>"> پیوست شماره <?php echo e($loop->index + 1); ?><i class="remixicon-file-download-line  mr-1 align-middle"></i></a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if((config('ticket_signature') == 'superior' or config('ticket_signature') == 'both') and $reply->user->signature): ?>
                            <div class="signature">
                                <?php echo clean(nl2br($reply->user->signature)); ?>

                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <!-- REPORT TICKET MODAL -->

     <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.modal','data' => ['title' => 'گزارش تیکت','id' => 'reportTicketModal','formId' => 'reportTicketForm','isAjax' => 'true','action' => ''.e(route('panel.reports.store')).'','method' => 'post']]); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['title' => 'گزارش تیکت','id' => 'reportTicketModal','formId' => 'reportTicketForm','isAjax' => 'true','action' => ''.e(route('panel.reports.store')).'','method' => 'post']); ?>
        <input type="hidden" name="ticket_id" value="<?php echo e($ticket->id); ?>"/>
        <input type="hidden" name="reply_id" id="replyId" value="">
        <div class="alert alert-info">گزارش شما مستقیما توسط مدیریت بررسی خواهد شد</div>
        <div class="form-group">
            <label for="reportContent">متن گزارش</label>
            <textarea name="content" id="reportContent" class="form-control" cols="30" rows="5" placeholder="متن گزارش را وارد کنید..."></textarea>
        </div>
        <div class="result alert" style="display:none"></div>
     <?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?> 

    <!-- ADD QUICK RESPONSE MODAL -->

     <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.modal','data' => ['title' => 'انتخاب پاسخ آماده','id' => 'quickResponsesModal']]); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['title' => 'انتخاب پاسخ آماده','id' => 'quickResponsesModal']); ?>
        <div class="accordion accordion-flush" id="quickResponsesAccordion">
            <?php $__empty_1 = true; $__currentLoopData = $quickResponses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quickResponse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="accordion-item bg-light mb-1 border-0">
                    <h2 class="accordion-header" id="quick-response-header-<?php echo e($loop->iteration); ?>">
                        <button class="accordion-button collapsed" type="button" data-toggle="collapse" data-target="#qs<?php echo e($loop->iteration); ?>" aria-expanded="false" aria-controls="quick-response-<?php echo e($loop->iteration); ?>">
                            <?php echo e($quickResponse->title); ?>

                        </button>
                    </h2>
                    <div id="qs<?php echo e($loop->iteration); ?>" class="accordion-collapse collapse" aria-labelledby="quick-response-header-<?php echo e($loop->iteration); ?>" data-parent="#quickResponsesAccordion" style="">
                        <div class="accordion-body"><?php echo e($quickResponse->text); ?></div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <p>داده‌ای یافت نشد</p>
            <?php endif; ?>

            <?php if(count($quickResponses) > 0): ?>
                <button class="btn btn-sm btn-secondary float-right select-quick-response-btn" disabled>انتخاب</button>
            <?php endif; ?>

        </div>
     <?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?> 


    <!-- DROPZONE UPLOAD MODAL -->

     <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.modal','data' => ['title' => 'افزودن فایل به تیکت','id' => 'addFileToTicketModal','size' => 'modal-lg']]); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['title' => 'افزودن فایل به تیکت','id' => 'addFileToTicketModal','size' => 'modal-lg']); ?>
        <div class="alert alert-light border-right">
            <span>شما میتوانید حداکثر </span>
            <span class="text-primary"><?php echo e(config('upload_max_file_count')); ?></span>
            <span> تا فایل آپلود کنید</span>
        </div>
        <div class="alert alert-light border-right">
            <span>هر فایل شما نباید بیشتر از </span>
            <span class="text-primary"><?php echo e(config('upload_max_file_size')); ?></span>
            <span>  مگابایت حجم داشته باشد</span>
        </div>
        <form action="<?php echo e(route('panel.tickets.storeFile')); ?>" method="post" class="dropzone" id="addFileForm" data-plugin="dropzone" data-previews-container="#file-previews"
              data-upload-preview-template="#uploadPreviewTemplate">
            <?php echo csrf_field(); ?>
            <div class="fallback">
                <input name="file" type="file" multiple />
            </div>

            <div class="dz-message needsclick">
                <p class="h1 text-muted"><i class="mdi mdi-cloud-upload"></i></p>
                <h3>فایل ها را برای آپلود به اینجا بکشید و رها کنید</h3>
            </div>
        </form>

        <!-- Preview -->
        <div class="dropzone-previews mt-3" id="file-previews"></div>
     <?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?> 

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <?php
        $timeout = 999;
        if (ini_get('max_input_time') == -1) {
            $timeout = ini_get('max_execution_time');
        } elseif (ini_get('max_input_time') > 0) {
            $timeout = ini_get('max_input_time');
        }

        $timeout *= 1000;
    ?>
    <script>
    $(document).ready(function(){

        $('#quickResponsesAccordion').on('hidden.bs.collapse', function () {
            $('.select-quick-response-btn').attr('disabled', 'disabled')
        })

        $('#quickResponsesAccordion').on('shown.bs.collapse', function () {
            $('.select-quick-response-btn').removeAttr('disabled')
        })

        $('.select-quick-response-btn').click(function() {
            $('#ReplyText').html('')
            $('#ReplyText').html($('#quickResponsesAccordion .accordion-collapse.collapse.show .accordion-body').html())
            $('#quickResponsesModal').modal('hide')
        })

        // check if url has #reply-* to focus that reply
        if(window.location.hash.indexOf('reply-') > -1){
            $(window.location.hash).parent().addClass('focused-reply');
            $('html, body').animate({
                scrollTop: $(window.location.hash).parent().offset().top - 80
            }, 1300)
        }
    });

    var uploadedDocumentMap = {}
    var filesCount = 0
    Dropzone.options.addFileForm = {
        /*url: '',*/
        maxFilesize: '<?php echo e(config('upload_max_file_size')); ?>', // MB
        maxFiles: '<?php echo e(config('upload_max_file_count')); ?>',
        timeout: '<?php echo e($timeout); ?>',
        addRemoveLinks: true,
        acceptedFiles: '<?php echo e(config('upload_allowed_formats')); ?>',
        headers: {
            'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>"
        },
        success: function (file, response) {
            $('#addReplyForm')
                .append('<input type="hidden" name="attach[]" value="' + response.name + '" id="' + response.id + '">')
            $('#addReplyForm')
                .append('<input type="hidden" name="attachName[]" value="' + response.original_name + '" data-related="#' + response.id + '">')
            uploadedDocumentMap[file.name] = response.name
            $('.files-count').text($('input[name="attach[]"]').length)
        },
        removedfile: function (file) {
            file.previewElement.remove()
            var name = ''
            if (typeof file.file_name !== 'undefined') {
                name = file.file_name
            } else {
                name = uploadedDocumentMap[file.name]
            }
            var attachInput = $('#addReplyForm').find('input[name="attach[]"][value="' + name + '"]');
            attachInput.remove();
            $('#addReplyForm').find('[data-related="#' + attachInput.attr('id') + '"]').remove()
            $('.files-count').text($('input[name="attach[]"]').length)
        },
    }
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iphoneun/public_html/peygirsho.ir/patronic/resources/views/panel/tickets/show.blade.php ENDPATH**/ ?>