
<?php $__env->startSection('title', 'ویرایش پشتیبان'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('panel.users.index')); ?>">پشتیبانان</a></li>
                        <li class="breadcrumb-item active">ویرایش پشتیبان</li>
                    </ol>
                </div>
                <h4 class="page-title">ویرایش پشتیبان</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row">
        <div class="col">
            <div class="card-box clearfix">
                <div class="card-header mb-3">
                    <h4 class="header-title">اطلاعات پشتیبان</h4>
                </div>
                <?php if(session('success')): ?>
                    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                <?php endif; ?>
                <form action="<?php echo e(route('panel.staffs.update', $staff)); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('patch'); ?>
                    <div class="row">
                        <div class="col-12">
                            <div class="p-1">
                                <div class="form-group">
                                    <label for="name" class="form-label">نام و نام خانوادگی</label>
                                    <input type="text" name="name" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="name" placeholder="نام و نام خانوادگی را وارد کنید" value="<?php echo e($staff->name); ?>" required/>
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group">
                                    <label for="email" class="form-label">ایمیل</label>
                                    <input type="email" name="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="email" placeholder="مثال: email@site.com" value="<?php echo e($staff->email); ?>" required/>
                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group">
                                    <label for="mobile" class="form-label">شماره موبایل</label>
                                    <input type="text" name="mobile" class="form-control <?php $__errorArgs = ['mobile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="mobile" placeholder="مثال: 09123456789" title="شماره تماس 11 رقمی مانند: 09123456789" pattern="09\d{9}" value="<?php echo e($staff->mobile); ?>" required/>
                                    <?php $__errorArgs = ['mobile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="form-group">
                                    <label for="password" class="form-label">کلمه عبور</label>
                                    <input type="password" name="password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="password" placeholder="کلمه عبور را وارد کنید" title="حداقل 8 کارکتر" min="8" aria-describedby="passwordDesc"/>
                                    <small class="form-text text-muted" id="passwordDesc">در صورتی که نمیخواهید کلمه عبور کاربر را تغییر دهید این بخش را خالی رها کنید</small>
                                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="form-group">
                                    <label for="StaffDepartments">دپارتمان</label>
                                    <select id="StaffDepartments" dir="rtl" name="departments[]" class="selectpicker" multiple data-selected-text-format="count > 3" data-style="btn-light">
                                        <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($department->id); ?>" <?php if(in_array($department->id, $staffDepartments)): ?> selected <?php endif; ?>><?php echo e($department->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <p>وضعیت</p>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" id="activeStatus" name="status" class="custom-control-input" <?php echo e($staff->status == 'active' ? 'checked' : ''); ?> value="active">
                                        <label class="custom-control-label" for="activeStatus">فعال</label>
                                    </div>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" id="disabledStatus" name="status" class="custom-control-input" <?php echo e($staff->status == 'disabled' ? 'checked' : ''); ?> value="disabled">
                                        <label class="custom-control-label" for="disabledStatus">غیر فعال</label>
                                    </div>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" id="bannedStatus" name="status" class="custom-control-input" <?php echo e($staff->status == 'banned' ? 'checked' : ''); ?> value="banned">
                                        <label class="custom-control-label" for="bannedStatus">مسدود شده</label>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" <?php echo e($staff->mobile_verified_at ? 'checked' : ''); ?> id="mobileVerified" name="mobileVerified" value="<?php echo e($staff->mobile_verified_at ?: \Carbon\Carbon::now()); ?>">
                                        <label class="custom-control-label" for="mobileVerified">موبایل تایید شده است</label>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" <?php echo e($staff->email_verified_at ? 'checked' : ''); ?> id="emailVerified" name="emailVerified" value="<?php echo e($staff->email_verified_at ?: \Carbon\Carbon::now()); ?>">
                                        <label class="custom-control-label" for="emailVerified">ایمیل تایید شده است</label>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary waves-effect waves-light float-right">ذخیره</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div><!-- end col -->
    </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iphoneun/public_html/peygirsho.ir/patronic/resources/views/panel/staffs/edit.blade.php ENDPATH**/ ?>