@extends('layouts.setup.master')

@section('content')
    <div class="container mt-5">
        <div class="card">
            <div class="card-body">
                <div class="text-center mb-1 float-right">
                    <a href="https://patronic.ir" class="text-muted" target="_blank">
                        <img src="{{ asset('assets/images/patronic-logo-dark.png') }}" alt="سیستم پشتیبانی و ارسال تیکت پاترونیک" class="mb-1" height="35">
                        <p>www.patronic.ir</p>
                    </a>
                </div>
                <h3 class="card-title">مرحله چهارم نصب - اطلاعات حساب کاربری مدیر</h3>
                <p class="card-subtitle">ایجاد حساب کاربری مدیر سامانه</p>
                <hr>
                <div class="row">

                    @include('layouts.setup.vertical-tabs')

                    <div class="col-9">
                        <div class="tab-content pt-0" id="v-pills-tabContent">
                            <div class="tab-pane fade show active" id="v-pills-admin-account" role="tabpanel" aria-labelledby="v-pills-admin-account-tab">
                                @error('accountError')
                                <div class="alert alert-danger"><strong>خطا! </strong>{{ $message }}</div>
                                @enderror
                                <form action="{{ route('setup.handle', ['step' => 4]) }}" method="post">
                                    @csrf
                                    <div class="form-group">
                                        <label for="Name">نام و نام خانوادگی</label>
                                        <input type="text" class="form-control @error('name') is-invalid @enderror" id="Name" name="name" value="{{ old('name') }}" placeholder="نام و نام خانوادگی را وارد کنید" required>
                                        @error('name')
                                        <div class="invalid-feedback">
                                            <span>{{ $message }}</span>
                                        </div>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="Email">ایمیل</label>
                                        <input type="email" class="form-control @error('email') is-invalid @enderror" id="Email" name="email" value="{{ old('email') }}" placeholder="ایمیل را وارد کنید" required>
                                        @error('email')
                                        <div class="invalid-feedback">
                                            <span>{{ $message }}</span>
                                        </div>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="Password">کلمه عبور</label>
                                        <input type="password" class="form-control @error('password') is-invalid @enderror" id="Password" name="password" placeholder="کلمه عبور را وارد کنید" required>
                                        @error('password')
                                        <div class="invalid-feedback">
                                            <span>{{ $message }}</span>
                                        </div>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="RePassword">تکرار کلمه عبور</label>
                                        <input type="password" class="form-control" id="RePassword" name="password_confirmation" placeholder="تکرار کلمه عبور را وارد کنید" required>
                                    </div>
                                    <div class="alert alert-light border-right text-primary">تکمیل فرآیند نصب و راه اندازی ممکن است کمی زمانبر باشد لذا تا پایان یافتن نصب و نمایش پیغام موفقیت شکیبا باشید</div>
                                    <div class="form-group clearfix">
                                        <button type="submit" class="btn btn-primary float-right">مرحله بعد</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection