@extends('layouts.master')
@section('title', 'مشاهده گزارش')

@section('breadcrumb')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('panel.tickets.index') }}">گزارشات کاربران</a></li>
                        <li class="breadcrumb-item active">مشاهده گزارش</li>
                    </ol>
                </div>
                <h4 class="page-title">مشاهده گزارش</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col">
            <div class="card-box">
                <p class="text-muted">
                    <span>ایجاد شده توسط : </span>
                    <a href="{{ route('panel.users.show', $report->user) }}">{{ $report->user->name }}</a>
                    <span>برای تیکت با موضوع : </span>
                    <a href="{{ route('panel.tickets.show', $report->ticket) }}" target="_blank">{{ $report->ticket->subject }}</a>
                    @if($report->isForReply())
                        <span>برای شماره پاسخ : </span>
                        <a  target="_blank" href="{{ route('panel.tickets.show', $report->ticket) . '#reply-' . $report->reply->id }}">{{ $report->reply->id }}</a>
                    @endif
                    <span> در تاریخ : </span>
                    <span class="text-dark">@jalali($report->created_at)</span>
                </p>
                <div class="alert border-light">
                    <h6>متن گزارش:</h6>
                    {!! clean(nl2br($report->content)) !!}
                </div>

            </div>
        </div>
    </div>

@endsection