@extends('layouts.master')
@section('title', 'ویرایش نوشته')

@section('breadcrumb')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('panel.users.index') }}">اخبار و سوالات متداول</a></li>
                        <li class="breadcrumb-item active">ویرایش</li>
                    </ol>
                </div>
                <h4 class="page-title">ویرایش نوشته</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col">
            <div class="card-box clearfix">
                <div class="card-header mb-3">
                    <h4 class="header-title">اطلاعات نوشته</h4>
                </div>
                @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                <form action="{{ route('panel.posts.update', $post) }}" method="post">
                    @method('patch')
                    @csrf
                    <div class="row">
                        <div class="col-sm-9">
                            <div class="p-1">
                                <div class="form-group">
                                    <label for="title" class="form-label">عنوان</label>
                                    <input type="text" name="title" class="form-control @error('title') is-invalid @enderror" id="title" placeholder="عنوان نوشته را وارد کنید" value="{{ old('title') ?: $post->title }}" required/>
                                    @error('title')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="form-group">
                                    <label for="richtext">متن</label>
                                    @error('text')
                                    <p class="text-danger" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </p>
                                    @enderror
                                    <textarea name="text" class="form-control" id="richtext" cols="30" rows="20" placeholder="متن نوشته را وارد کنید">{{ clean(old('text')) ?: clean($post->content) }}</textarea>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="post-side">
                                <div id="post-status" class="border-bottom border-white pb-2 mb-2">
                                    <h5 class="header-title pb-2">وضعیت</h5>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" name="postStatus" value="public" id="public" class="custom-control-input"  {{ (old('postStatus') == 'public' or $post->status == 'public') ? 'checked' : '' }}/>
                                        <label for="public" class="custom-control-label">عمومی</label>
                                    </div>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" name="postStatus" id="draft" value="draft" class="custom-control-input" {{ (old('postStatus') == 'draft' or $post->status == 'draft') ? 'checked' : '' }}/>
                                        <label for="draft" class="custom-control-label">پیش نویس</label>
                                        <span class="remixicon-question-fill" data-toggle="tooltip" title="با انتخاب این گزینه نوشته شما به عنوان پیش نویس ذخیره خواهد و نمایش داده نمیشود"></span>
                                    </div>
                                </div>
                                <div id="post-type" class="pb-2 mb-1">
                                    <h5 class="header-title mb-2">نوع</h5>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" name="postType" id="news" value="news" class="custom-control-input" {{ (old('postType') == 'news' or $post->type == 'news') ? 'checked' : '' }}/>
                                        <label for="news" class="custom-control-label">اخبار</label>
                                    </div>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" name="postType" id="faq" value="faq" class="custom-control-input"{{ (old('postType') == 'faq' or $post->type == 'faq') ? 'checked' : '' }}/>
                                        <label for="faq" class="custom-control-label">سوالات متداول</label>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-bordered-success btn-block waves-effect waves-light">ذخیره</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div><!-- end col -->
    </div>

@endsection

@section('script')
    <script src="{{ asset('assets/js/tinymce/tinymce.min.js') }}"></script>
    <script>
        tinymce.init({
            selector:'#richtext',
            directionality: 'rtl',
            language: 'fa_IR',
            content_css: '{{ asset('assets/css/app-rtl.min.css') }}',
            plugins: "link,image",
            image_uploadtab: true,
            menubar: 'edit insert view format table',
            plugins: [
                "advlist autolink lists link image charmap preview hr anchor pagebreak",
                "searchreplace wordcount visualblocks visualchars code fullscreen",
                "insertdatetime media save table contextmenu directionality",
                "paste textcolor colorpicker textpattern"
            ],
            toolbar: "insertfile undo redo | formatselect styleselect | bold italic strikethrough forecolor backcolor permanentpen formatpainter | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image media | fullscreen code",
            images_upload_handler: function (blobInfo, success, failure) {
                var xhr, formData;

                xhr = new XMLHttpRequest();
                xhr.withCredentials = false;
                xhr.open('POST', '{{ route('panel.posts.addMedia') }}');

                xhr.onload = function() {
                    var json;

                    if (xhr.status != 200) {
                        failure('HTTP Error: ' + xhr.status);
                        return;
                    }

                    json = JSON.parse(xhr.responseText);

                    if (!json || typeof json.location != 'string') {
                        failure('Invalid JSON: ' + xhr.responseText);
                        return;
                    }

                    success(json.location);
                };

                formData = new FormData();
                formData.append('file', blobInfo.blob(), blobInfo.filename());
                formData.append('_token', '{{ csrf_token() }}');

                xhr.send(formData);
            }
        })
    </script>
@endsection