<?php

namespace App\Policies;

use App\Ticket;
use App\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class TicketPolicy
{
    use HandlesAuthorization;


    public function before(User $user, $ability)
    {
        if ($user->role == 'admin' or $user->role == 'superadmin') {
            return true;
        }
    }

    /**
     * Determine whether the user can view any tickets.
     *
     * @param  \App\User  $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        return $user->isSuperior();
    }

    /**
     * Determine whether the user can view the ticket.
     *
     * @param  \App\User  $user
     * @param  \App\Ticket  $ticket
     * @return mixed
     */
    public function view(User $user, Ticket $ticket)
    {
        if ($user->isUser()) {
            return $ticket->user_id == $user->id;
        } elseif ($user->isStaff()) {
            return in_array($ticket->department->id, $user->department()->pluck('id')->toArray());
        } else {
            return false;
        }
    }

    /**
     * Determine whether the user can create tickets.
     *
     * @param  \App\User  $user
     * @return mixed
     */
    public function create(User $user)
    {
        if (($user->isStaff() and config('can_staff_create_ticket')) or $user->isUser()) {
            return true;
        }
        return false;
    }

    /**
     * Determine whether the user can update the ticket.
     *
     * @param  \App\User  $user
     * @param  \App\Ticket  $ticket
     * @return mixed
     */
    public function update(User $user, Ticket $ticket)
    {
        //
    }

    /**
     * Determine whether the user can delete the ticket.
     *
     * @param  \App\User  $user
     * @param  \App\Ticket  $ticket
     * @return mixed
     */
    public function delete(User $user, Ticket $ticket)
    {
        return $ticket->user_id == $user->id;
    }

    /**
     * Determine whether the user can restore the ticket.
     *
     * @param  \App\User  $user
     * @param  \App\Ticket  $ticket
     * @return mixed
     */
    public function restore(User $user, Ticket $ticket)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the ticket.
     *
     * @param  \App\User  $user
     * @param  \App\Ticket  $ticket
     * @return mixed
     */
    public function forceDelete(User $user, Ticket $ticket)
    {
        if ($user->isUser()) {
            return $ticket->user_id == $user->id;
        } elseif ($user->isStaff()) {
            return in_array($ticket->department->id, $user->department()->pluck('id')->toArray());
        } else {
            return false;
        }
    }

    public function downloadAttach(User $user, Ticket $ticket)
    {
        if ($user->isUser()) {
            return $ticket->user_id == $user->id;
        } elseif ($user->isStaff()) {
            return in_array($ticket->department->id, $user->department()->pluck('id')->toArray());
        } else {
            return false;
        }
    }
}
