@extends('layouts.user-panel.master')
@section('breadcrumb')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <h4 class="page-title">تغییر کلمه عبور</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')
    <div class="row">
        <div class="col">
            <div class="card-box">
                <div class="clearfix">
                    <div class="float-left">
                        <h4 class="header-title">حساب کاربری</h4>
                        <p class="sub-header">تغییر کلمه عبور</p>
                    </div>
                </div>
                @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                <div class="card-body">
                    @error('authError')
                    <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                    <form action="{{ route('panel.password.update') }}" method="post">
                        @csrf
                        <div class="form-group row">
                            <div class="col">
                                <input type="password" name="currentPassword" class="form-control @error('currentPassword') is-invalid @enderror" placeholder="کلمه عبور فعلی را وار کنید" required/>
                                @error('currentPassword')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                            <div class="col">
                                <input type="password" id="password" name="password" class="form-control @error('password') is-invalid @enderror" placeholder="کلمه عبور جدید را وار کنید" required/>
                                @error('password')
                                <div class="invalid-feedback">
                                    {{ $message }}
                                </div>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group clearfix mb-0">
                            <button type="submit" class="btn btn-success float-right">تغییر کلمه عبور</button>
                        </div>
                    </form>
                </div>
            </div>
        </div><!-- end col -->

    </div>
    <!-- end row -->
@endsection