@extends('layouts.master')
@section('title', 'تنظیمات عمومی')

@section('breadcrumb')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('panel.settings.general') }}">تنظیمات</a></li>
                        <li class="breadcrumb-item active">عمومی</li>
                    </ol>
                </div>
                <h4 class="page-title">تنظیمات عمومی</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col">
            <div class="card-box">
                @if(session('success'))
                    <div class="alert alert-success">
                        {{ session('success') }}
                    </div>
                @endif
                <form action="{{ route('panel.settings.general.update') }}" class="form-horizontal" method="post" role="form" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="siteTitle">عنوان سایت</label>
                        <div class="col-sm-10">
                            <input type="text" name="site_title" class="form-control" id="siteTitle" placeholder="عنوان سایت را وارد کنید" value="{{ $settings['site_title'] }}"/>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="siteUrl">آدرس سایت</label>
                        <div class="col-sm-10">
                            <input type="text" name="site_url" class="form-control" id="siteUrl" value="{{ $settings['site_url'] }}" disabled readonly/>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="siteEmail">ایمیل سایت</label>
                        <div class="col-sm-10">
                            <input type="text" name="site_email" class="form-control" id="siteEmail" value="{{ $settings['site_email'] }}" placeholder="مثال: noreply@site.com"/>
                            <small class="form-text text-muted">در بخش from ایمیل های اطلاع رسانی این آدرس نمایش داده خواهد شد</small>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="siteLogo">لوگوی متنی</label>
                        <div class="col-sm-10">
                            <input type="text" name="site_logo" class="form-control" id="siteLogo" value="{{ $settings['site_logo'] }}" placeholder="مثال: پاترونیک"/>
                            <small class="form-text text-warning">با وارد کردن لوگوی متنی تصویر لوگو در صفحات سایت نمایش داده نخواهد شد.برای نمایش تصویر لوگو این قسمت را خالی رها کنید</small>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="siteLogoImg">تصویر لوگو</label>
                        <div class="col-sm-10">
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" name="site_logo_img" id="customFile" lang="fa">
                                <label class="custom-file-label" for="customFile">{{ $settings['site_logo_img'] ?: 'انتخاب فایل...' }}</label>
                            </div>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="siteHomepageEnabled">صفحه اصلی نمایش داده شود</label>
                        <div class="col-sm-10 p-1 pl-2">
                            <input type="checkbox" id="siteHomepageEnabled" data-plugin="switchery" data-size="small" data-color="#1AB394" data-secondary-color="#ED5565" name="site_homepage_enabled" @if($settings['site_homepage_enabled']) checked @endif value="1" />
                            <small class="form-text text-muted">با غیرفعال کردن این گزینه کاربران مستقیما وارد صفحه ورود خواهند شد و صفحه اصلی را مشاهده نخواهند کرد</small>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="emailNotificationEnabled">اطلاع رسانی از طریق ایمیل</label>
                        <div class="col-sm-10 p-1 pl-2">
                            <input type="checkbox" id="emailNotificationEnabled" data-plugin="switchery" data-size="small" data-color="#1AB394" data-secondary-color="#ED5565" name="email_notifications" @if($settings['email_notifications']) checked @endif value="1" />
                            <small class="form-text text-muted">با فعال بودن این گزینه تیکت ها و پاسخ ها به کاربران و پشتیبانان از طریق ایمیل اطلاع رسانی میشود</small>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="SmsNotificationsEnabled">اطلاع رسانی از طریق پیامک</label>
                        <div class="col-sm-10 p-1 pl-2">
                            <input type="checkbox" id="SmsNotificationsEnabled" data-plugin="switchery" data-size="small" data-color="#1AB394" data-secondary-color="#ED5565" name="sms_notifications" @if($settings['sms_notifications']) checked @endif value="1" />
                            <small class="form-text text-muted">با فعال بودن این گزینه تیکت ها و پاسخ ها به کاربران و پشتیبانان از طریق پیامک اطلاع رسانی میشود</small>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="MustVerifyEmail">تایید ایمیل</label>
                        <div class="col-sm-10 p-1 pl-2">
                            <input type="checkbox" id="MustVerifyEmail" data-plugin="switchery" data-size="small" data-color="#1AB394" data-secondary-color="#ED5565" name="must_verify_email" @if($settings['must_verify_email']) checked @endif value="1" />
                            <small class="form-text text-muted">با فعال بودن این گزینه کاربران پس از ثبت نام میبایست ایمیل خود را از طریق لینک فعالسازی که برایشان ایمیل میشود فعالسازی کنند تا بتوانند وارد سایت شوند</small>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="MustVerifyMobile">تایید موبایل</label>
                        <div class="col-sm-10 p-1 pl-2">
                            <input type="checkbox" id="MustVerifyMobile" data-plugin="switchery" data-size="small" data-color="#1AB394" data-secondary-color="#ED5565" name="must_verify_mobile" @if($settings['must_verify_mobile']) checked @endif value="1" />
                            <small class="form-text text-muted">با فعال بودن این گزینه کاربران پس از ثبت نام میبایست شماره موبایل خود را از طریق کد تاییدی که برایشان پیامک میشود تایید کنند تا بتوانند وارد سایت شوند</small>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="RegistrationEnabled">ثبت نام فعال باشد</label>
                        <div class="col-sm-10 p-1 pl-2">
                            <input type="checkbox" id="RegistrationEnabled" data-plugin="switchery" data-size="small" data-color="#1AB394" data-secondary-color="#ED5565" name="register_enabled" @if($settings['register_enabled']) checked @endif value="1" />
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="Rules">قوانین و مقررات</label>
                        <div class="col-sm-10 p-1 pl-2">
                            <textarea name="rules" id="Rules" class="form-control" cols="30" rows="6" placeholder="قوانین و مقررات را بنویسید...">{{ $settings['rules'] }}</textarea>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label" for="GoogleNoCaptchaEnabled">کپتچای گوگل</label>
                        <div class="col-sm-10 p-1 pl-2">
                            <input type="checkbox" id="GoogleNoCaptchaEnabled" data-plugin="switchery" data-size="small" data-color="#1AB394" data-secondary-color="#ED5565" name="use_google_nocaptcha" @if($settings['use_google_nocaptcha']) checked @endif value="1" />
                        </div>
                    </div>
                    <div class="form-group row" @if(!$settings['use_google_nocaptcha']) style="display: none" @endif>
                        <label class="col-sm-2 col-form-label" for="googleNocaptchaSecret">google nocaptcha secret</label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" id="googleNocaptchaSecret" value="{{ $settings['google_nocaptcha_secret'] }}" name="google_nocaptcha_secret" placeholder="Enter Your Secret Key here..."/>
                        </div>
                    </div>
                    <div class="form-group row" @if(!$settings['use_google_nocaptcha']) style="display: none" @endif>
                        <label class="col-sm-2 col-form-label" for="googleNocaptchaSitekey">google nocaptcha sitekey</label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" id="googleNocaptchaSitekey" value="{{ $settings['google_nocaptcha_sitekey'] }}" name="google_nocaptcha_sitekey" placeholder="Enter Your Site Key here..."/>
                        </div>
                    </div>
                    <div class="clearfix border-top pt-2 border-light">
                        <button class="btn btn-primary float-right" type="submit">ذخیره</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection