@extends('layouts.master')
@section('title', 'گزارشات کاربران')

@section('breadcrumb')
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">پنل کاربری</a></li>
                        <li class="breadcrumb-item active">گزارشات کاربران</li>
                    </ol>
                </div>
                <h4 class="page-title">گزارشات کاربران</h4>
            </div>
        </div>
    </div>
    <!-- end page title -->
@endsection

@section('content')

    <div class="row">
        <div class="col">
            <div class="card-box">
                <div class="clearfix">
                    <div class="float-left">
                        <h4 class="header-title">لیست گزارشات کاربران</h4>
                        <p class="sub-header">لیست گزارشاتی که کاربران و پشتیبانان از تیکت ها و پاسخ ها ارسال کرده اند</p>
                    </div>
                </div>
                @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                <div class="table-responsive">
                    <table class="table table-hover text-center">
                        <thead class="thead-light">
                        <tr>
                            <th>#</th>
                            <th>تیکت</th>
                            <th>کاربر</th>
                            <th>پشتیبان</th>
                            <th>وضعیت</th>
                            <th>تاریخ</th>
                            <th>گزینه ها</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($reports as $report)
                            <tr>
                                <td>{{ $report->id }}</td>
                                <td><a href="{{ route('panel.tickets.show', $report->ticket) }}" target="_blank">{{ $report->ticket->subject }}</a></td>
                                <td><a href="{{ route('panel.users.show', $report->user) }}" target="_blank">{{ $report->user->name }}</a></td>
                                <td>{{ $report->reply->user->name ?? ' - ' }}</td>
                                <td>{!! $report->isRead() ? '<span class="badge badge-light-primary">مشاهده شده</span>': '<span class="badge badge-light-warning">مشاهده نشده</span>' !!}</td>
                                <td title="@jalali($report->created_at)">@jalali($report->created_at,true)</td>
                                <td><a href="{{ route('panel.reports.show', $report) }}">مشاهده</a></td>
                            </tr>
                        @empty
                            <td colspan="7" class="bg-light text-muted text-center">داده ای یافت نشد</td>
                        @endforelse
                        </tbody>
                    </table>
                </div>
                {{ $reports->links() }}
            </div>
        </div><!-- end col -->
    </div>

@endsection