<div id="{{ $id }}" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="{{ $id.'Label' }}">
    <div class="modal-dialog {{ $size ?? '' }}">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="{{ $id.'Label' }}">{{ $title }}</h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            @if(isset($formId))
                <form action="{{ $action ?? '' }}" method="{{ $method ?? ''}}" id="{{ $formId ?? '' }}" @if(isset($isAjax)) {{'data-ajax-form=true'}} @endif @if(isset($redirectUrl)) data-redirect-url="{{ $redirectUrl ?? '' }}" @endif data-parsley-validate>
                    @csrf
            @endif
            <div class="modal-body">
                {{ $slot }}
            </div>
            <div class="modal-footer">
                <button type="button" data-dismiss="modal" class="btn btn-bordered-light waves-effect text-secondary">بستن</button>
            @if(isset($formId))
                <button type="reset" class="btn btn-bordered-secondary waves-effect waves-light">پاکسازی فرم</button>
                <button type="submit" class="btn btn-bordered-primary waves-effect waves-light submit-btn">ذخیره</button>
            @endif
            </div>
            @if(isset($formId))
                </form>
            @endif
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>