var from, to;

$(document).ready(function () {
    var now_url = window.location.href;
    var array = now_url.split("/");
    var my_item_index = array.length - 1;
    if (array[my_item_index] == 'layouts-sidebar-sm') {
        document.body.setAttribute('class', '');
        document.body.classList.add('left-side-menu-sm');
    } else if (array[my_item_index] == 'layouts-dark-sidebar') {
        document.body.setAttribute('class', '');
        document.body.classList.add('left-side-menu-dark');
    } else if (array[my_item_index] == 'layouts-light-topbar') {
        document.body.setAttribute('class', '');
        document.body.classList.add('left-side-menu-dark');
        document.body.classList.add('topbar-light');
    } else if (array[my_item_index] == 'layouts-sidebar-collapsed') {
        document.body.setAttribute('class', '');
        document.body.classList.add('enlarged');
    } else if (array[my_item_index] == 'layouts-boxed') {
        document.body.setAttribute('class', '');
        document.body.classList.add('enlarged');
        document.body.classList.add('boxed-layout');
    } else {

    }

    function preloader_fun() {
        document.getElementById("if_need_loader").style.display = "block";
        document.getElementById("preloader").style.display = "block";
        document.getElementById("status").style.display = "block";
        setTimeout(function () {
            document.getElementById("if_need_loader").style.display = "none";
        }, 1500);
    }

    $('#password').passtrength({
        passwordToggle: true,
        eyeImg: $('body').attr('data-app-url') + '/assets/images/eye.svg',
        tooltip: true,
        textWeak: "ضعیف",
        textMedium: "متوسط",
        textStrong: "قوی",
        textVeryStrong: "بسیار قوی",
    });

    const swal = Swal.mixin({
        confirmButtonText: 'باشه'
    });

    $.ajaxSetup({
        'headers': {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $('[data-ajax-form]').submit(function (e) {
        e.preventDefault();
        var form = $(this);
        var result = form.find('.result');
        var subbtn = form.find(':submit');
        subbtn.attr('disabled', 'disabled').html('<span class="spinner-border spinner-border-sm mr-1" role="status" aria-hidden="true"></span>در حال پردازش...');
        result.fadeOut();
        $.ajax({
            url: form.attr('action'),
            type: form.attr('method'),
            dataType: 'json',
            data: form.serialize(),
            error: function (error) {
                if (error.hasOwnProperty('responseJSON')) {
                    if (error.responseJSON.message !== '') {
                        $('.result').addClass('alert-danger').removeClass('alert-success').html(error.responseJSON.message)
                    }
                }
            },
            success: function (response) {
                if (response.status === 'success') {
                    result.addClass('alert-success').removeClass('alert-danger').html(response.msg);
                    var attr = form.attr('data-redirect-url');
                    if (typeof attr !== typeof undefined && attr !== false) {
                        window.setTimeout(function () {
                            window.location.href = form.attr('data-redirect-url');
                        }, 800);
                    }
                } else if (response.status === 'fail') {
                    result.addClass('alert-danger').removeClass('alert-success').html(response.msg);
                } else {
                    result.addClass('alert-danger').removeClass('alert-success').html('خطایی بوجود آمده است');
                }
            },
            complete: function () {
                result.fadeIn();
                subbtn.removeAttr('disabled').html('ذخیره');
            }
        })
    });

    $('html').on('click', 'td [data-delete-url]', function () {
        var elem = $(this);
        swal.fire({
            title: 'آیا از حذف اطلاعات اطمینان دارید؟',
            text: "مورد انتخاب شده حذف خواهد شد و این عمل قابل بازگردانی نخواهد بود!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'حذف کن',
            cancelButtonText: 'انصراف',
        }).then((result) => {
            if (result.value) {

                $.ajax({
                    url: elem.attr('data-delete-url'),
                    type: 'DELETE',
                    dataType: 'json',
                    error: function (error) {
                        if (error.hasOwnProperty('responseJSON')) {
                            if (error.responseJSON.message !== '') {
                                swal.fire('انجام نشد', error.responseJSON.message, 'error')
                            }
                        }
                    },
                    success: function (response) {
                        if (response.status === 'success') {
                            elem.parents('tr').addClass('table-danger').fadeOut();
                        } else if (response.status === 'fail') {
                            swal.fire('انجام نشد', 'مشکلی در حذف بوجود آمده است', 'error')
                        } else {
                            swal.fire('انجام نشد', 'مشکلی در حذف بوجود آمده است', 'error')
                        }
                    }
                });
            }
        })
    });

    // Validation errors messages for Parsley
    // Load this after Parsley

    Parsley.addMessages('fa', {
        defaultMessage: "مقداری که برای این فیلد وارد شده است نامعتبر است",
        type: {
            email: "ایمیل وارد شده نامعتبر است",
            url: "آدرس وارد شده نامعتبر است",
            number: "مقدار وارد شده نامعتبر است تنها مقادیر عددی مورد پذیرش هستند",
            integer: "مقدار وارد شده نامعتبر است تنها مقادیر عددی مورد پذیرش هستند",
            digits: "مقدار وارد شده نامعتبر است تنها مقادیر عددی مورد پذیرش هستند",
            alphanum: "مقدار وارد شده نامعتبر است تنها حروف الفبا مورد پذیرش هستند"
        },
        notblank: "وارد کردن این بخش الزامی است",
        required: "تکمیل کردن این بخش الزامی است",
        pattern: "مقدار وارد شده نامعتبر است",
        min: "این مقدیر باید بزرگتر یا مساوی %s باشد",
        max: "این مقدار باید کمتر و یا مساوی %s باشد",
        range: "این مقدار باید بین %s و %s باشد",
        minlength: "این مقدار بیش از حد کوتاه است. باید %s کاراکتر یا بیشتر باشد.",
        maxlength: "این مقدار بیش از حد طولانی است. باید %s کاراکتر یا کمتر باشد.",
        length: "این مقدار نامعتبر است و باید بین %s و %s باشد",
        mincheck: "شما حداقل باید %s گزینه را انتخاب کنید.",
        maxcheck: "شما حداکثر می‌توانید %s انتخاب داشته باشید.",
        check: "باید بین %s و %s مورد انتخاب کنید",
        equalto: "این مقدار باید یکسان باشد"
    });
    Parsley.setLocale('fa');

    $('[data-filter-status]').click(function () {
        $(this).toggleClass('active');
        $('tr[data-status=' + $(this).attr('data-filter-status') + ']').toggle();
        if ($(this).attr('data-filter-status') == 'closed') {
            $('tr[data-is-closed=1]').toggle();
        }
    });

    $('[data-close-ticket]').click(function () {
        var elem = $(this);
        swal.fire({
            title: 'آیا از بستن تیکت اطمینان دارید؟',
            text: "تیکت بسته خواهد شد و کاربران امکان ارسال پاسخ به این تیکت را نخواهند داشت",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'تیکت را ببند',
            cancelButtonText: 'انصراف',
        }).then((result) => {
            if (result.value) {
                elem.attr('disabled', 'disabled').html('<span class="spinner-border spinner-border-sm mr-1" role="status" aria-hidden="true"></span>در حال پردازش...');
                $.ajax({
                    url: elem.attr('data-close-ticket'),
                    type: 'PATCH',
                    dataType: 'json',
                    error: function (error) {
                        if (error.hasOwnProperty('responseJSON')) {
                            if (error.responseJSON.message !== '') {
                                swal.fire('انجام نشد', error.responseJSON.message, 'error')
                            }
                        }
                    },
                    success: function (response) {
                        if (response.status === 'success') {
                            swal.fire('انجام شد', 'وضعیت تیکت با موفقیت به بسته تغییر پیدا کرد', 'success');
                            window.setTimeout(function () {
                                window.location.reload();
                            }, 1000);
                        } else if (response.status === 'fail') {
                            swal.fire('انجام نشد', 'مشکلی در بستن تیکت بوجود آمده است', 'error')
                        } else {
                            swal.fire('انجام نشد', 'مشکلی در بستن تیکت بوجود آمده است', 'error')
                        }
                    },
                    complete: function () {
                        elem.removeAttr('disabled').html('بستن تیکت');
                    }
                });
            }
        })
    });

    $('[data-reopen-ticket]').click(function () {
        var elem = $(this);
        swal.fire({
            title: 'آیا از بازگشایی تیکت اطمینان دارید؟',
            text: "تیکت مجددا به حالت عادی بازگشته و کاربران امکان ارسال پاسخ به این تیکت را خواهند داشت",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'تیکت را باز کن',
            cancelButtonText: 'انصراف',
        }).then((result) => {
            if (result.value) {
                elem.attr('disabled', 'disabled').html('<span class="spinner-border spinner-border-sm mr-1" role="status" aria-hidden="true"></span>در حال پردازش...');
                $.ajax({
                    url: elem.attr('data-reopen-ticket'),
                    type: 'PATCH',
                    dataType: 'json',
                    error: function (error) {
                        if (error.hasOwnProperty('responseJSON')) {
                            if (error.responseJSON.message !== '') {
                                swal.fire('انجام نشد', error.responseJSON.message, 'error')
                            }
                        }
                    },
                    success: function (response) {
                        if (response.status === 'success') {
                            swal.fire('انجام شد', 'وضعیت تیکت به حالت باز تغییر پیدا کرد', 'success');
                            window.setTimeout(function () {
                                window.location.reload();
                            }, 1000);
                        } else if (response.status === 'fail') {
                            swal.fire('انجام نشد', 'مشکلی در بازگشایی تیکت بوجود آمده است', 'error')
                        } else {
                            swal.fire('انجام نشد', 'مشکلی در بازگشایی تیکت بوجود آمده است', 'error')
                        }
                    },
                    complete: function () {
                        elem.removeAttr('disabled').html('بازگشایی تیکت');
                    }
                });
            }
        })
    });

    $('#DepartmentsList').change(function () {
        var elem = $(this);
        elem.attr('disabled', 'disabled');
        $.ajax({
            url: elem.attr('data-refer-ticket'),
            data: {department: elem.val()},
            type: 'PATCH',
            dataType: 'json',
            error: function (error) {
                if (error.hasOwnProperty('responseJSON')) {
                    if (error.responseJSON.message !== '') {
                        swal.fire('انجام نشد', error.responseJSON.message, 'error')
                    }
                }
            },
            success: function (response) {
                if (response.status === 'success') {
                    swal.fire('انجام شد', response.msg, 'success');
                    window.setTimeout(function () {
                        window.location.reload();
                    }, 1000);
                } else if (response.status === 'fail') {
                    swal.fire('انجام نشد', 'مشکلی در ارجاع تیکت بوجود آمده است', 'error')
                } else {
                    swal.fire('انجام نشد', 'مشکلی در ارجاع تیکت بوجود آمده است', 'error')
                }
            },
            complete: function () {
                elem.removeAttr('disabled');
            }
        });
    });

    $('.star-rating.rated').starRating({
        readOnly: true,
        totalStars: 5,
        starShape: 'rounded',
        starSize: 20,
        emptyColor: 'lightgray',
        hoverColor: 'salmon',
        activeColor: 'crimson',
        useGradient: false
    });

    $('.star-rating').starRating({
        totalStars: 5,
        starShape: 'rounded',
        starSize: 20,
        emptyColor: 'lightgray',
        hoverColor: 'salmon',
        activeColor: 'crimson',
        useGradient: false,
        callback: function (rate, $elem) {
            $elem.after('<small class="fa fa-spin fa-spinner adding-rate"></small>');
            $.post($elem.attr('data-rate-reply'), {rate: rate}, function (response) {
                if (response.hasOwnProperty('status') && response.status === 'success') {
                    window.setTimeout(function () {
                        $('body').find('.adding-rate').hide();
                        $($elem).after('<small class="text-success">امتیاز شما ثبت شد</small>');
                    }, 1500)
                } else alert('ثبت نشد');
            }, 'json');
        }
    });


    $('[data-mark-as-unread]').click(function () {
        var elem = $(this);
        $.ajax({
            url: elem.attr('data-mark-as-unread'),
            type: 'PATCH',
            dataType: 'json',
            error: function (error) {
                if (error.hasOwnProperty('responseJSON')) {
                    if (error.responseJSON.message !== '') {
                        swal.fire('انجام نشد', error.responseJSON.message, 'error')
                    }
                }
            },
            success: function (response) {
                if (response.status === 'success') {
                    swal.fire('انجام شد', response.msg, 'success');
                    window.setTimeout(function () {
                        window.location.reload();
                    }, 1000);
                } else if (response.status === 'fail') {
                    swal.fire('انجام نشد', 'مشکلی بوجود آمده است', 'error')
                } else {
                    swal.fire('انجام نشد', 'مشکلی بوجود آمده است', 'error')
                }
            },
            complete: function () {
                elem.removeAttr('disabled');
            }
        });
    });

    $('[data-report-reply]').click(function (e) {
        e.preventDefault();
        $('#replyId').val($(this).attr('data-report-reply'));
    });

    $('#sendTestSmsForm').submit(function (e) {
        e.preventDefault();
        var form = $(this);
        var btn = form.find(':submit');

        if ($('#mobile').val() == '') {
            return alert('شماره موبایل را وارد کنید');
        }

        $.ajax({
            url: form.attr('action'),
            type: 'GET',
            data: {driver: $('#smsDriver').val(), action: 'sendTestSms', mobile: $('#mobile').val()},
            beforeSend: function () {
                btn.attr('disabled', 'disabled').html('<i class="fa fa-spinner fa-spin"></i>');
            },
            complete: function () {
                btn.removeAttr('disabled').html('ارسال پیامک آزمایشی') ;
            },
            success: function (response) {
                if (response.status === 'success') {
                    swal.fire('انجام شد', 'ارسال پیامک با موفقیت انجام شد.چنانچه پیامک دریافت نمیگردد مشکل را از طریق سامانه پیامکی پیگیری بفرمایید', 'success');
                } else if (response.status === 'fail') {
                    swal.fire('انجام نشد', response.msg, 'error')
                } else {
                    swal.fire('انجام نشد', 'مشکلی بوجود آمده است', 'error')
                }
            },
            error: function (error) {
                if (error.hasOwnProperty('responseJSON')) {
                    if (error.responseJSON.message !== '') {
                        swal.fire('انجام نشد', error.responseJSON.message, 'error')
                    }
                }
            },
        });
    });

    $('#sendTestEmailForm').submit(function (e) {
        e.preventDefault();
        var form = $(this);
        var btn = form.find(':submit');

        if ($('#email').val() == '') {
            return alert('ایمیل را وارد کنید');
        }

        $.ajax({
            url: form.attr('action'),
            type: 'GET',
            data: {email: $('#email').val()},
            beforeSend: function () {
                btn.attr('disabled', 'disabled').html('<i class="fa fa-spinner fa-spin"></i>');
            },
            complete: function () {
                btn.removeAttr('disabled').html('ارسال ایمیل آزمایشی');
            },
            success: function (response) {
                if (response.status === 'success') {
                    swal.fire('انجام شد', 'عملیات ارسال ایمیل با موفقیت صورت گرفت.چنانچه ایمیل دریافت نمیگردد از صحت اطلاعات وارد شده در بخش تنظیمات ایمیل اطمینان حاصل فرمایید', 'success');
                } else if (response.status === 'fail') {
                    swal.fire('انجام نشد', response.msg, 'error')
                } else {
                    swal.fire('انجام نشد', 'مشکلی بوجود آمده است', 'error')
                }
            },
            error: function (error) {
                if (error.hasOwnProperty('responseJSON')) {
                    if (error.responseJSON.message !== '') {
                        swal.fire('انجام نشد', error.responseJSON.message, 'error')
                    }
                }
            },
        });
    });

    $('.custom-file-input').change(function (e) {
        var fileName = e.target.files[0].name;
        $(this).siblings('label').html(fileName);
    });

    $('[data-plugin="switchery"]').each(function (t, e) {
        new Switchery($(this)[0], $(this).data())
    })

    $('#GoogleNoCaptchaEnabled').change(function () {
        if ($(this).prop('checked')) {
            $('#googleNocaptchaSecret').parent().parent().fadeIn();
            $('#googleNocaptchaSitekey').parent().parent().fadeIn();
        } else {
            $('#googleNocaptchaSecret').parent().parent().fadeOut();
            $('#googleNocaptchaSitekey').parent().parent().fadeOut();
        }
    });

    $('#addReplyBtn').click(function () {
        $('body').find('#ReplyText').focus();
        if ($(this).attr('aria-expanded') === 'false') {
            $('body,html').animate({
                scrollTop: 450
            }, 1200);
        }
    });

    to = $(".to-date").persianDatepicker({
        observer: true,
        format: 'YYYY/MM/DD',
        inline: true,
        altField: '.to-date-inp',
        altFormat: 'L',
        initialValue: false,
        "toolbox": {
            "enabled": true,
            "calendarSwitch": {
                "enabled": false,
                "format": "MMMM"
            },
        },
        onSelect: function (unix) {
            $('#toDate').val(unix);
            to.touched = true;
            if (from && from.options && from.options.maxDate != unix) {
                var cachedValue = from.getState().selected.unixDate;
                from.options = {maxDate: unix};
                if (from.touched) {
                    from.setDate(cachedValue);
                }
            }
        }
    });

    from = $(".from-date").persianDatepicker({
        observer: true,
        inline: true,
        format: 'YYYY/MM/DD',
        altField: '.from-date-inp',
        altFormat: 'L',
        initialValue: false,
        "toolbox": {
            "enabled": true,
            "calendarSwitch": {
                "enabled": false,
                "format": "MMMM"
            },
        },
        onSelect: function (unix) {
            $('#fromDate').val(unix);
            from.touched = true;
            if (to && to.options && to.options.minDate != unix) {
                var cachedValue = to.getState().selected.unixDate;
                to.options = {minDate: unix};
                if (to.touched) {
                    to.setDate(cachedValue);
                }
            }
        }
    });

    $('.clear-date').click(function () {
        $(this).siblings('input').val('');
        $($(this).attr('data-field')).val('');
    });


    $('.select2-ajax').select2({
        language: 'fa',
        ajax: {
            url: $(this).attr('data-ajax-url'),
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                return {
                    results: data.items,
                };
            },
            cache: true
        },
        minimumInputLength: 3,
        placeholder: $(this).attr('data-placeholder')
    });

    $('.carousel').carousel({
        interval: 500
    })

});