<?php

namespace App\Console\Commands;

use App\User;
use Illuminate\Console\Command;

class ResetDemoUsers extends Command
{
    protected $signature = 'demo:reset-users';

    protected $description = 'reset demo users username and password';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $demoUsers = [
            [
                'email' => 'admin@demo.com',
                'password' => 'admin123456',
                'name' => 'patronic admin',
                'role' => 'admin',
                'email_verified_at' => now(),
                'mobile' => '09123456789',
                'mobile_verified_at' => now(),
                'status' => 'active'
            ],
            [
                'email' => 'staff@demo.com',
                'password' => 'staff123456',
                'name' => 'patronic staff',
                'role' => 'staff',
                'email_verified_at' => now(),
                'mobile' => '09123456799',
                'mobile_verified_at' => now(),
                'status' => 'active'
            ],
            [
                'email' => 'user@demo.com',
                'password' => 'user123456',
                'name' => 'patronic user',
                'role' => 'user',
                'email_verified_at' => now(),
                'mobile' => '09123456779',
                'mobile_verified_at' => now(),
                'status' => 'active'
            ],
        ];

        foreach ($demoUsers as $demoUser) {
            User::updateOrCreate(['email' => $demoUser['email']], $demoUser);
        }

        return 0;
    }
}
