<?php

namespace App\Http\Controllers\panel;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class NotificationController extends Controller
{

    /**
     * Gets all unread Notifications for current user
     * @return mixed
     */
    public function getAll()
    {
        return auth()->user()->unreadNotifications;
    }

    /**
     * Mark specified notification as read
     * @param Request $request
     * @return mixed
     */
    public function markAsRead(Request $request)
    {
        $request->validate([
            'id' => 'required'
        ]);

        $notification = auth()->user()->unreadNotifications()->find($request->id);
        $notification->markAsRead();

        return response()->json(['status' => 'success']);
    }
}
